package com.yy.pushsvc.facknotification;

import android.content.Intent;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.yy.hiidostatis.defs.obj.Property;
import com.yy.pushsvc.R;
import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.template.ClickIntentUtil;
import com.yy.pushsvc.template.NoficationBar;
import com.yy.pushsvc.template.OnViewClickListener;
import com.yy.pushsvc.template.PushNotModleUtil;
import com.yy.pushsvc.template.TemplateManager;
import com.yy.pushsvc.template.ViewEntity;
import com.yy.pushsvc.template.YYPushCustomViewUtil;
import com.yy.pushsvc.util.PushLog;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by GuanYuFeng
 * on 2020/1/9
 */
public class ViewBuilder {
    private static final String TAG = "FackViewBuilder";

    public  View getNotificationView(NotificationEntity entity,
                                           LinearLayout notificationView, NotificationActivity context) {
        View view = null;
        YYPushCustomViewUtil yyPushCustomViewUtil = new YYPushCustomViewUtil();
        ViewEntity mainRV = null;
        ViewEntity largeRV = null;
        try {
            JSONObject payload = new JSONObject(entity.payload);
            if (payload == null) {
                return view;
            }

            final PushNotModleUtil pm = PushNotModleUtil.getInstance(context);
            String pushModel = pm.getFromData(entity.pushModel + "");

            //走系统默认样式
            if (TextUtils.isEmpty(pushModel)) {
                String title = entity.title;
                String desc = entity.desc;
                view = LayoutInflater.from(context).inflate(R.layout.view_notification_default,
                        notificationView, false);
                ImageView ivHead = view.findViewById(R.id.iv_head);
                int imgId = TemplateManager.getInstance().getConfig().getLargeIconResourceId();
                ivHead.setImageResource(imgId);

                TextView tvTitle = view.findViewById(R.id.tv_title);
                tvTitle.setText(title);
                TextView tvContent = view.findViewById(R.id.tv_content);
                tvContent.setText(desc);
                boolean isDark = new NoficationBar().isDarkNotificationBar(context);
                if (isDark) {
                    tvTitle.setTextColor(Color.WHITE);
                    tvContent.setTextColor(Color.WHITE);
                }
                defaultClick(view, entity, context);
            } else {
                yyPushCustomViewUtil.init(entity.pushId,
                        entity.msgId,
                        entity.channelType,
                        payload,
                        context,
                        false,
                        pushModel,
                        TemplateManager.getInstance().getConfig().getImgFailCallback());
                // if (entity.hasLarge) {
                //     largeRV = yyPushCustomViewUtil.parsePushCustomContent(false, notificationView,
                //             new MyViewClickListener(context));
                //     if (largeRV != null && largeRV.mView != null) {
                //         view = largeRV.mView;
                //     }
                // }
                // if (view == null) {
                    mainRV = yyPushCustomViewUtil.parsePushCustomContent(false, notificationView,
                            new MyViewClickListener(context));
                    if (mainRV != null && mainRV.mView != null) {
                        view = mainRV.mView;
                    }
                // }
                if (view != null) {
                    yyPushCustomViewUtil.handlePushImages();
                }
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + ",showNotification(),erro=" + e.toString());
        }
        return view;
    }

    private void defaultClick(View view, NotificationEntity entity, NotificationActivity context) {
        if (view == null || context == null || entity == null) {
            return;
        }
        view.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    Intent in = TemplateManager.getInstance()
                            .getClassIntent(new JSONObject(entity.payload),
                                    entity.notificationId, entity.msgId,entity.channelType);
                    context.sendBroadcast(in);
                    reportClick(in);
                    context.finishAct();
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void reportClick(Intent in) {
        try {
            if (in != null) {
                long msgId = in.getLongExtra(ClickIntentUtil.MSG_ID, 0);
                String pushId = in.getStringExtra(ClickIntentUtil.PUSHI_D);
                String channelType = in.getStringExtra(ClickIntentUtil.CHANNEL_TYPE);
                Property property = new Property();
                property.putString("msgid", String.valueOf(msgId));
                property.putString("pushid", String.valueOf(pushId));
                PushReporter.getInstance()
                        .reportNotificationEventToHiido(
                                FackConst.HIIDO_PUSH_FACK_NOTIFICATION_CLICKED,
                                channelType, property);
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + ",reportClick,erro=" + e);
        }
    }

    class MyViewClickListener implements OnViewClickListener {
        private NotificationActivity act;

        public MyViewClickListener(NotificationActivity act) {
            this.act = act;
        }

        @Override
        public void onViewClick(Intent in) {
            act.sendBroadcast(in);
            reportClick(in);
            act.finishAct();
        }
    }
}
