package com.yy.pushsvc.facknotification;

import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

import com.yy.pushsvc.util.PushLog;

/**
 * Created by GuanYuFeng
 * on 2020/1/3
 */
public class ScreenManager {
    private static final String TAG = "ScreenManager";
    private static ScreenManager instance;
    private Context context;
    private BroadcastReceiver screenReceiver = new ScreenManager.ScreenBroadcastReceiver();
    private boolean unLock;

    private ScreenManager(Context context) {
        try {
            if (!(context instanceof Application)) {
                context = context.getApplicationContext();
            }
            this.context = context;
            registerResceiver();
            KeyguardManager mKeyguardManager =
                    (KeyguardManager) context.getSystemService(Context.KEYGUARD_SERVICE);
            boolean flag = mKeyguardManager.inKeyguardRestrictedInputMode();
            unLock = !flag;
        } catch (Throwable t) {
            PushLog.inst().log(TAG + "ScreenManager,erro = " + t);
        }
    }

    public static ScreenManager getInstance(Context context) {
        synchronized (ScreenManager.class) {
            if (instance == null) {
                instance = new ScreenManager(context);
            }
        }
        return instance;
    }

    public boolean isUnLock() {
        return unLock;
    }

    private void registerResceiver() {
        try {
            IntentFilter filter = new IntentFilter();
            filter.addAction(Intent.ACTION_SCREEN_OFF);
            filter.addAction(Intent.ACTION_USER_PRESENT);
            context.registerReceiver(screenReceiver, filter);
        } catch (Throwable t) {
            PushLog.inst().log(TAG + "registerResceiver,erro = " + t);
        }
    }

    public void onScreenOff() {
        unLock = false;
        PushLog.inst().log(TAG + ",onScreenOff");
    }

    private void onUnlockScreen() {
        unLock = true;
        PushLog.inst().log(TAG + ",onUnlockScreen ");
        NotificationEntity entity = ScreenCache.getInstance().getEntity(context);
        FackManager.getInstance().showNotification(context, entity, true);
    }

    /**
     * screen状态广播接收者
     */
    private class ScreenBroadcastReceiver extends BroadcastReceiver {

        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                String action = intent.getAction();
                if (Intent.ACTION_SCREEN_OFF.equals(action)) { // 黑屏
                    onScreenOff();
                } else if (Intent.ACTION_USER_PRESENT.equals(action)) { //解锁
                    onUnlockScreen();
                }
            } catch (Throwable t) {
                PushLog.inst().log(TAG + ",onReceive(),erro=" + t.toString());
            }
        }
    }
}
