package com.yy.pushsvc.facknotification;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;

import com.yy.hiidostatis.defs.obj.Property;
import com.yy.pushsvc.IMsgArriveCallback;
import com.yy.pushsvc.R;
import com.yy.pushsvc.locknotification.ClipLinearview;
import com.yy.pushsvc.receiver.YYPushMsgDispacher;
import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.template.NoficationBar;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.ScreenUtil;

/**
 * Created by GuanYuFeng
 * on 2019/12/30
 */
public class NotificationActivity extends Activity {
    private static final String TAG = "NotificationActivity";
    private static final String INTENT_ENTITY = "INTENT_ENTITY";
    private static final long NOTIFICATION_SHOW_DELAY = 2000;
    private static final float FLIP_DISTANCE = 50;
    private NotificationEntity entity;
    private ClipLinearview notificationView;
    private GestureDetector mDetector;
    private FakeNotificationConfig fackConfig = FackManager.getInstance().getFackConfig();
    private long createTime = 0;
    private boolean isFinishAct = false;

    public static void startMyself(Context context, NotificationEntity entity) {
        if (entity == null) {
            return;
        }
        Intent in = new Intent(context, NotificationActivity.class);
        in.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
        in.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        in.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        in.putExtra(INTENT_ENTITY, entity);
        context.startActivity(in);
        PushLog.inst().log(TAG + ",startActivity()");
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            PushLog.inst().log(TAG + ",onCreate()");
            createTime = System.currentTimeMillis();
            entity = (NotificationEntity) getIntent().getSerializableExtra(INTENT_ENTITY);
            hideNavigation();
            setStatusBarColor();
            setContentView(R.layout.notification_act);
            notificationView = findViewById(R.id.notification_view);
            notificationView.setRadius(5);
            if (ScreenUtil.isLandscape(this)) {
                LinearLayout.LayoutParams lp =
                        (LinearLayout.LayoutParams) notificationView.getLayoutParams();
                lp.width = getNotificationWidth();
                notificationView.setLayoutParams(lp);
            }
            boolean isDark = new NoficationBar().isDarkNotificationBar(this);
            notificationView.setBackgroundColor(isDark ? Color.BLACK : Color.WHITE);
            View view = new ViewBuilder().getNotificationView(entity, notificationView,
                    this);
            if (view == null) {
                PushLog.inst().log(TAG + ",view=null");
                finish();
            } else {
                notificationView.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            if (!isFinishing() && notificationView != null) {
                                topMoveToViewLocation(notificationView, 300);
                                notificationView.addView(view);
                                hideNotificationView();
                            }
                        } catch (Throwable t) {
                            PushLog.inst().log(TAG + ".erro= " + t.toString());
                        }
                    }
                }, NOTIFICATION_SHOW_DELAY);
                reportShow(entity.msgId, entity.pushId, entity.payload, entity.channelType);
            }
            initDetector();
        } catch (Throwable t) {
            finish();
            PushLog.inst().log(TAG + ",onCreate(),erro=" + t.toString());
        }
    }

    private void reportShow(long msgId,String payload, String pushId, String channelType) {
        YYPushMsgDispacher.getInstance().onPushSDKNotificationShow(msgId, payload.getBytes(),
                channelType, IMsgArriveCallback.NOTIFICATION_LOCK_TYPE, this);
        Property property = new Property();
        property.putString("msgid", String.valueOf(msgId));
        property.putString("pushid", String.valueOf(pushId));
        PushReporter.getInstance()
                .reportNotificationEventToHiido(
                        FackConst.HIIDO_PUSH_FACK_NOTIFICATION_SHOW,
                        channelType, property);
    }

    private int getNotificationWidth() {
        int width = 0;
        WindowManager wm = (WindowManager) getSystemService(Context.WINDOW_SERVICE);
        DisplayMetrics dm = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(dm);
        if (ScreenUtil.isLandscape(this)) {
            width = dm.heightPixels;
        } else {
            width = dm.widthPixels;
        }
        return width;
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        try {
            if (mDetector != null) {
                boolean is = mDetector.onTouchEvent(ev);
                if (is) {
                    return true;
                }
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ".erro= " + t.toString());
        }
        return super.dispatchTouchEvent(ev);
    }

    private void initDetector() {
        mDetector = new GestureDetector(this, new GestureDetector.SimpleOnGestureListener() {
            @Override
            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX,
                                   float velocityY) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - createTime > NOTIFICATION_SHOW_DELAY) {
                    if (e1.getX() - e2.getX() > FLIP_DISTANCE) {
                        PushLog.inst().log(TAG + ",向左滑...");
                        finishAct();
                        return true;
                    }
                    if (e2.getX() - e1.getX() > FLIP_DISTANCE) {
                        PushLog.inst().log(TAG + ",向右滑...");
                        finishAct();
                        return true;
                    }
                    if (e1.getY() - e2.getY() > FLIP_DISTANCE) {
                        PushLog.inst().log(TAG + ",向上滑...");
                        finishAct();
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public void topMoveToViewLocation(View v, long duration) {
        v.setVisibility(View.VISIBLE);
        TranslateAnimation mShowAction = new TranslateAnimation(Animation.RELATIVE_TO_SELF, 0.0f,
                Animation.RELATIVE_TO_SELF, 0.0f, Animation.RELATIVE_TO_SELF,
                -1.0f, Animation.RELATIVE_TO_SELF, 0.0f);
        mShowAction.setDuration(duration);
        v.clearAnimation();
        v.setAnimation(mShowAction);
    }

    public void topFinishToViewLocation(View v, long duration) {
        TranslateAnimation mShowAction = new TranslateAnimation(Animation.RELATIVE_TO_SELF, 0.0f,
                Animation.RELATIVE_TO_SELF, 0.0f, Animation.RELATIVE_TO_SELF,
                0.0f, Animation.RELATIVE_TO_SELF, -1.0f);
        mShowAction.setDuration(duration);
        v.clearAnimation();
        v.setAnimation(mShowAction);
        v.setVisibility(View.GONE);
    }

    public  void finishAct() {
        try {
            if (isFinishAct) {
                return;
            }
            isFinishAct = true;
            topFinishToViewLocation(notificationView, 300);
            notificationView.postDelayed(new Runnable() {
                @Override
                public void run() {
                    try {
                        if (!isFinishing()) {
                            finish();
                        }
                    } catch (Throwable t) {
                        PushLog.inst().log(TAG + ",finishAct,erro=" + t);
                    }
                }
            }, 400);
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",finishAct,erro=" + t);
            finish();
        }
    }

    private void hideNotificationView() {
        PushLog.inst().log(TAG + ",showTime=" + fackConfig.getShowTime());
        notificationView.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (!isFinishing()) {
                    finishAct();
                }
            }
        }, fackConfig.getShowTime());
    }

    private void hideNavigation() {
        WindowManager.LayoutParams params = getWindow().getAttributes();
        params.systemUiVisibility =
                View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_IMMERSIVE;
        getWindow().setAttributes(params);
    }

    private void setStatusBarColor() {
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
        getWindow().clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            getWindow().setStatusBarColor(Color.TRANSPARENT);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        PushLog.inst().log(TAG + ",onDestroy");
    }

    @Override
    public void finish() {
        super.finish();
        overridePendingTransition(0, R.anim.notification_finish_exit);
    }
}
