package com.yy.pushsvc.facknotification;

import java.io.Serializable;

/**
 * Created by GuanYuFeng
 * on 2020/1/14
 */
public class FakeNotificationConfig implements Serializable {

    /**
     * 是否开启假通知功能，false关闭，true开启
     */
    private boolean fakeNotificationEnble = false;

    /**
     * true只有在解锁的时候显示假通知；false收到就显示(跟普通消息一样)
     */
    private boolean onlyUnlockShow = false;

    /**
     * true横屏也显示假通知，false不显示
     */
    private boolean landscapeEnable = true;

    /**
     * 假通知显示时间，单位毫秒，默认3000毫秒收起
     */
    private int showTime = 3000;

    /**
     * 默认配置
     */
    public static FakeNotificationConfig getDefault() {
        return new FakeNotificationConfig(false, false, true, 3000);
    }

    public FakeNotificationConfig() {
    }

    public FakeNotificationConfig(boolean fakeNotificationEnble, boolean onlyUnlockShow,
                                  boolean landscapeEnable, int showTime) {
        this.fakeNotificationEnble = fakeNotificationEnble;
        this.onlyUnlockShow = onlyUnlockShow;
        this.landscapeEnable = landscapeEnable;
        this.showTime = showTime;
    }

    public boolean isFakeNotificationEnble() {
        return fakeNotificationEnble;
    }

    public void setFakeNotificationEnble(boolean fakeNotificationEnble) {
        this.fakeNotificationEnble = fakeNotificationEnble;
    }

    public boolean isOnlyUnlockShow() {
        return onlyUnlockShow;
    }

    public void setOnlyUnlockShow(boolean onlyUnlockShow) {
        this.onlyUnlockShow = onlyUnlockShow;
    }

    public boolean isLandscapeEnable() {
        return landscapeEnable;
    }

    public void setLandscapeEnable(boolean landscapeEnable) {
        this.landscapeEnable = landscapeEnable;
    }

    public int getShowTime() {
        return showTime;
    }

    public void setShowTime(int showTime) {
        this.showTime = showTime;
    }
}
