package com.yy.pushsvc.facknotification;

import android.content.Context;

import com.yy.hiidostatis.defs.obj.Property;
import com.yy.pushsvc.receiver.YYPushMsgDispacher;
import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.util.NotificationUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.ScreenUtil;

/**
 * Created by GuanYuFeng
 * on 2020/1/14
 */
public class FackManager {
    private static final String TAG = "FackManager";
    private static volatile FackManager instance;
    private FakeNotificationConfig fackConfig = FakeNotificationConfig.getDefault();

    public static FackManager getInstance() {
        if (instance == null) {
            synchronized (FackManager.class) {
                if (instance == null) {
                    instance = new FackManager();
                }
            }
        }
        return instance;
    }

    private FackManager() {
        YYPushMsgDispacher.getInstance().addFirst(new FackIntercept());
    }

    public FackManager init(Context context) {
        ScreenManager.getInstance(context);
        return this;
    }

    public FakeNotificationConfig getFackConfig() {
        return fackConfig;
    }

    public void setFackConfig(FakeNotificationConfig fackConfig) {
        this.fackConfig = fackConfig;
    }

    /**
     * @param context
     * @param entity
     * @param fromCache true，屏幕解锁时从缓存取的数据；false从push下发
     */
    public  void showNotification(Context context, NotificationEntity entity, boolean fromCache) {
        try {
            PushLog.inst().log(TAG + ",context = " + context + ",entity=" + entity + ",fromCache=" +
                    fromCache);
            if (!fromCache) {
                reportArrive(entity.msgId, entity.pushId, entity.channelType);
            }

            //前台不显示
            if (!NotificationUtil.isAppIsInBackground(context)) {
                ScreenCache.getInstance().saveEntity(entity, context);
                PushLog.inst().log(TAG + ",in_foreground");
                return;
            }


            if (fackConfig != null && context != null && entity != null) {
                if (fackConfig.isFakeNotificationEnble()) {
                    if (!fromCache && fackConfig.isOnlyUnlockShow()) {
                        boolean hasCache = ScreenCache.getInstance().saveEntity(entity, context);
                    } else {
                        if (ScreenManager.getInstance(context).isUnLock()) {
                            if (ScreenUtil.isLandscape(context) && !fackConfig.isLandscapeEnable()) {
                                return;
                            }
                            NotificationActivity.startMyself(context, entity);
                        } else {
                            boolean hasCache =
                                    ScreenCache.getInstance().saveEntity(entity, context);
                        }
                    }
                }
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",showNotification(),erro=" + t.toString());
        }
    }

    private void reportArrive(long msgId, String pushId, String channelType) {
        try {
            Property property = new Property();
            property.putString("msgid", String.valueOf(msgId));
            property.putString("pushid", String.valueOf(pushId));
            PushReporter.getInstance()
                    .reportNotificationEventToHiido(
                            FackConst.HIIDO_PUSH_FACK_NOTIFICATION_ARRIVE,
                            channelType, property);
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",reportArrive ,erro =" + t);
        }
    }
}
