package com.yy.pushsvc.facknotification;

import android.content.Context;
import android.content.Intent;

import com.yy.pushsvc.IAcquireAppState;
import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.receiver.YYPushMsgDispacher;
import com.yy.pushsvc.template.TemplateManager;
import com.yy.pushsvc.util.NotificationUtil;
import com.yy.pushsvc.util.YYPushConsts;

import org.json.JSONObject;


/**
 * Created by GuanYuFeng
 * payload{
 * suspend_flag ： 1 //有通知权限&&suspend_flag ==1&&用户开启免打扰，
 * }
 *
 * on 2020/3/13
 */
public class FackIntercept implements YYPushMsgDispacher.IChainIntercept {
    private static final String SUSPEND_FLAG = "suspend_flag";
    @Override
    public boolean intercept(Intent intent, Context ctx) {
        if (!FackManager.getInstance().getFackConfig().isFakeNotificationEnble()) {
            return false;
        }

        try {
            boolean notificationEnble = NotificationUtil.isNotificationEnabled(ctx);
            if (intent.hasExtra(YYPushConsts.YY_PUSH_KEY_PAYLOAD)) {
                String channelType =
                        intent.getStringExtra(YYPushConsts.YY_PUSH_KEY_CHANNELTYPE);
                int pushType = intent.hasExtra(YYPushConsts.PUSH_TYPE) ?
                        intent.getIntExtra(YYPushConsts.PUSH_TYPE, YYPushConsts.PUSH_TYPE_FCM) :
                        YYPushConsts.PUSH_TYPE_FCM;
                long msgId = intent.getLongExtra(YYPushConsts.YY_PUSH_KEY_MSGID, 0);
                JSONObject payload = new JSONObject(
                        new String(intent.getByteArrayExtra(YYPushConsts.YY_PUSH_KEY_PAYLOAD),
                                "UTF-8"));

                int suspendFlag = payload.optInt(SUSPEND_FLAG, 0);
                if (suspendFlag == 1) {
                    IAcquireAppState acquireAppState = YYPush.getInstace().getAcquireAppState();
                    boolean unDisturb = false;
                    if (acquireAppState != null) {
                        unDisturb = acquireAppState.isUnDisturb();
                    }
                    if (!notificationEnble || unDisturb) {
                        int notificationId = NotificationUtil.createNotificationId(msgId);
                        int modelId = payload.getInt(TemplateManager.PUSH_NOTIFICATION_TYPE);
                        boolean hasLarge = false;
                        int largeModelId = 0;
                        if (payload.has(TemplateManager.PUSH_NOTIFICATION_LARGE_TYPE) &&
                                payload.has(TemplateManager.PUSH_NOTIFICATION_LARGE_DATA)) {
                            largeModelId =
                                    payload.getInt(TemplateManager.PUSH_NOTIFICATION_LARGE_TYPE);
                            JSONObject largePushData =
                                    payload.getJSONObject(
                                            TemplateManager.PUSH_NOTIFICATION_LARGE_DATA);
                            if (largeModelId > 0 && largePushData != null) {
                                hasLarge = true;
                            }
                        }
                        String title = payload.optString("title");
                        String desc = payload.optString("desc");
                        long pushID = intent.getLongExtra(YYPushConsts.YY_PUSH_KEY_PUSHID, 0);
                        String pushIdStr = pushID + "";
                        if (pushID == 0) {
                            pushIdStr = payload.optString("pushId");
                        }
                        checkNotification(ctx, modelId, payload, largeModelId, notificationId,
                                hasLarge,
                                msgId, pushType, channelType, title, desc, pushIdStr);
                        return true;
                    }
                }
            }
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    private void checkNotification(Context context, int modelId, JSONObject payload,
                                   int largeModelId, int notificationId, boolean hasLarge,
                                   long msgId, int pushType, String channelType, String title,
                                   String desc, String pushId) {
        NotificationEntity entity = new NotificationEntity(modelId, payload.toString(),
                largeModelId, notificationId, hasLarge,
                msgId, pushType, channelType, title, desc, pushId);
        FackManager.getInstance().showNotification(context, entity, false);
    }
}
