package com.yy.pushsvc.aidl;

import android.os.Parcel;
import android.os.Parcelable;

public class PushUnreadMsg implements Parcelable {

    public String type;
    public String jsonString;


    public PushUnreadMsg(String type, String jsonString) {
        this.type = type;
        this.jsonString = jsonString;
    }

    public PushUnreadMsg(Parcel in) {
        this.type = in.readString();
        this.jsonString = in.readString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.type);
        dest.writeString(this.jsonString);
    }

    public void readFromParcel(Parcel from) {
        this.type = from.readString();
        this.jsonString = from.readString();
    }

    @Override
    public String toString() {
        return "PushUnreadMsg{" +
                "type='" + type + '\'' +
                ", jsonString='" + jsonString + '\'' +
                '}';
    }

    public static final Parcelable.Creator<PushUnreadMsg> CREATOR = new Parcelable.Creator<PushUnreadMsg>() {

        @Override
        public PushUnreadMsg createFromParcel(Parcel source) {
            return new PushUnreadMsg(source);
        }

        @Override
        public PushUnreadMsg[] newArray(int size) {
            return new PushUnreadMsg[size];
        }
    };
}
