package com.yy.pushsvc;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.Log;

import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.huawei.hms.api.HuaweiApiClient;
import com.xiaomi.mipush.sdk.MiPushClient;
import com.xiaomi.push.service.receivers.NetworkStatusReceiver;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.pushsvc.executor.IPushTaskExecutor;
import com.yy.pushsvc.log.ILogHandler;
import com.yy.pushsvc.receiver.NetworkChangeReceiver;
import com.yy.pushsvc.receiver.OverseasWakedResultReceiver;
import com.yy.pushsvc.receiver.ScreenChangeReceiver;
import com.yy.pushsvc.receiver.YYPushCallBackManager;
import com.yy.pushsvc.receiver.YYPushKitErrorCodes;
import com.yy.pushsvc.receiver.YYPushMsgDispacher;
import com.yy.pushsvc.receiver.YYPushToken;
import com.yy.pushsvc.report.PushGetUnreadMsgHttp;
import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.report.TokenRegisterState;
import com.yy.pushsvc.report.YYDelTagHttp;
import com.yy.pushsvc.report.YYPushDeviceInfoHttp;
import com.yy.pushsvc.report.YYPushReportStatisticsHttp;
import com.yy.pushsvc.report.YYSetTagHttp;
import com.yy.pushsvc.report.YYTokenBindHttp;
import com.yy.pushsvc.report.YYTokenLoginHttp;
import com.yy.pushsvc.report.YYTokenUnBindHttp;
import com.yy.pushsvc.repush.RepushManager;
import com.yy.pushsvc.service.ForegroundLiveService;
import com.yy.pushsvc.service.KeepLiveJobService;
import com.yy.pushsvc.service.outline.FetchOutlineMsgLocalService;
import com.yy.pushsvc.service.outline.FetchOutlineMsgService;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.template.TemplateConfig;
import com.yy.pushsvc.template.TemplateManager;
import com.yy.pushsvc.thirdparty.PushOppoRegisterCallBack;
import com.yy.pushsvc.thirdparty.ThirdPartyPushType;
import com.yy.pushsvc.util.ActivityLifecycleHelper;
import com.yy.pushsvc.util.AppInfo;
import com.yy.pushsvc.util.AppPackageUtil;
import com.yy.pushsvc.util.ExecutorProvider;
import com.yy.pushsvc.util.PushFileHelper;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushSPHelper;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.StringUtil;
import com.yy.pushsvc.util.SystemUtil;
import com.yy.pushsvc.util.YYPushConsts;
import com.yy.pushsvc.util.YYPushStatisticEvent;
import com.yy.pushsvc.yunlog.KLogW;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

import androidx.annotation.NonNull;
import androidx.core.app.NotificationManagerCompat;
import cn.jpush.android.api.JPushInterface;
import cn.jpush.android.service.DaemonService;
import cn.jpush.android.service.DownloadProvider;

import static android.content.Context.ACCOUNT_SERVICE;

/**
 * Created by HUTAO on 2017/12/5.
 */
public class YYPush {
    private static String TAG = "YYPush";

    private static YYPush mIntance = null;
    private static volatile boolean mInit = false;

    // public  static String httpsDNS ="olaparty.com";
    public static String httpsDNS = "yy.com";

    public static final String GLOBAL_YY = "https://global-yypushsdk.";
    public static final String GLOBAL = "https://global-pushsdk.";

    private Context mContext = null;
    private String mXiaomiId = "";
    private String mXiaomiKey = "";
    private HuaweiApiClient client;
    private volatile boolean mIsUseJobSchedulerFlag = true;
    private volatile int mJobId = 0;
    private static Set<Integer> schedulerHour = new HashSet<>();
    private static int schedulerMinute = 20;
    private boolean isForground = false;
    private volatile boolean isAppCreate = false;
    private int second;
    private IAcquireAppState mAcquireAppState;
    private boolean jgEnable = true;
    private boolean isXMNetReceiverEnable = true;
    private boolean suspendStrategyEnable = false;
    private String grobalPrefix = GLOBAL_YY;

    public interface IYYPushTokenCallback {
        /**
         * 获取token成功
         */
        void onSuccess(String deviceToken);

        /**
         * 获取token失败
         *
         * @param errCode 错误代码 参考错误代码表 YYPushKitErrorCodes
         */
        void onFailed(YYPushKitErrorCodes errCode);

        /**
         * 上报fcm token
         *
         * @param fcmtoken
         */
        void onUpdateServerUninstallFcmToken(String fcmtoken);
    }

    public static YYPush getInstace() {
        if (mIntance == null) {
            mIntance = new YYPush();
        }
        return mIntance;
    }

    public void setAcquireAppState(IAcquireAppState acquireAppState) {
        mAcquireAppState = acquireAppState;
    }

    public IAcquireAppState getAcquireAppState() {
        return mAcquireAppState;
    }

    /**
     * 极光AlarmReceiver心跳间隔
     * @param second 设置心跳单位秒
     */
    public void setJguangHeart(int second) {
        this.second = second;
    }

    public void setHostName(Context context, String httpsDNS) {
        PushSPHelper.getInstance().setConfUrlDomain(context, httpsDNS);
        this.httpsDNS = httpsDNS;
        if (httpsDNS.contains("yy")) {
            setGrobalPrefix(GLOBAL_YY);
        } else {
            setGrobalPrefix(GLOBAL);
        }
    }

    public String getGrobalPrefix() {
        return grobalPrefix;
    }

    public void setGrobalPrefix(String grobalPrefix) {
        this.grobalPrefix = grobalPrefix;
    }

    private void initJguangHeart() {
        if (mContext != null && second > 0) {
            Bundle bundle = new Bundle();
            bundle.putInt("heartbeat_interval", second);
//            JCoreManager.setSDKConfigs(mContext, bundle);
        }
    }

    /***
     * Push SDK注册初始化接口
     * @param context application的context
     * @param callback 注册callback接收token上报到海度
     * @param xiaoMiAppid 小米appId
     * @param xiaoMiKey 小米appkey
     * @param appVer app版本号asyn
     * @param msgEventCallback  消息回调接口
     */
    public void init(Context context, IYYPushTokenCallback callback, String xiaoMiAppid,
                     String xiaoMiKey,
                     String appVer , IMsgArriveCallback msgEventCallback) {
        if (mInit) {
            PushLog.inst().log("YYPush.init already mInit=" + mInit);
            return;
        }
        PushSPHelper.getInstance().setConfUrlDomain(context,httpsDNS);
        mInit = true;
        mContext = context;
        if (AppPackageUtil.isGtServiceProcess(context)) {
            return;
        }
        onAppCreate(context);
        YYPushMsgDispacher.getInstance().init(context, msgEventCallback);
        //设置push sdk版本号
        mXiaomiId = xiaoMiAppid;
        mXiaomiKey = xiaoMiKey;
        KLogW.init(context);
        ScreenChangeReceiver.getInstance(context);
        RepushManager.getInstance().init(context);

        AppPushInfo.setXiaomiId(xiaoMiAppid);
        AppPushInfo.setXiaomiKey(xiaoMiKey);
        AppPushInfo.getYYPushVersion(context);
        AppPushInfo.setAppVersion(appVer);

        PushLog.inst().setTag("YYPush-App");

        YYPushToken.getInstance().register(callback);

        asyncinitAllPush(context);
        TemplateManager.getInstance().init(context);
    }


    private boolean mExtReportEnble;

    public boolean isExtReportEnble() {
        return mExtReportEnble;
    }

    public void setExtReportEnble(boolean extReportEnble) {
        mExtReportEnble = extReportEnble;
    }

    public void setTemplateConfig(TemplateConfig config) {
        TemplateManager.getInstance().setConfig(config);
    }

    /**
     * 默认关闭云日志功能
     *
     * @param yunlogOpen 是否开启云日志功能
     */
    public void setYunlogOpen(boolean yunlogOpen) {
        KLogW.init(mContext);
        KLogW.setYunlogOpen(yunlogOpen);
    }

    /***
     * 设置push sdk日志路径
     * @param logDir push sdk日志路径
     */
    public void setLogDir(String logDir) {
        PushLog.inst().setupLogDir(logDir);
    }

    /***
     * 设置push ILogHandler
     */
    public void setLogHandle(ILogHandler lLogHandler) {
        PushLog.inst().setLogHandler(lLogHandler);
    }


    private void asyncinitAllPush(final Context context) {
        PushThreadPool.getPool().execute(new Runnable() {
            @Override
            public void run() {
                PushFileHelper.instance().init(context);
                setLogPathToFile(PushLog.inst().getLogPath());
                PushLog.inst().init(context);
                PushLog.inst().log("YYPush.asyncinitAllPush use ThirdPartyPush, manufacturer=" +
                        Build.MANUFACTURER
                        + ", sdkVersion:" + AppPushInfo.getYYPushVersion(context));

                try {
                    createNotificationChannel();
                } catch (Throwable e) {
                    PushLog.inst().log("YYPush.asyncinitAllPush createNotificationChannel " + Log.getStackTraceString(e));
                }

                //初始化本地存储
                TokenStore.getInstance().init(context);

                //有DB操作，比较繁重
                PushReporter.getInstance().init(context);


                //拉取未读消息
                if (AppPushInfo.getIsNeedGetUnreadMsg()) {
                    PushGetUnreadMsgHttp.getInstance().getUnreadMsgFromPushServer(context);
                }
                //上报注册push sdk事件
                PushReporter.getInstance()
                        .reportRegisterEventToHiido(YYPushConsts.REGISTER_PUSH_SDK_STATE);
                boolean permission = false;
                try {
                    permission =
                            NotificationManagerCompat.from(context.getApplicationContext())
                                    .areNotificationsEnabled();
                } catch (Exception e) {
                    Log.e(TAG, "run exception:" + e);
                }

                PushReporter.getInstance()
                        .reportEvent(YYPushStatisticEvent.PUSH_INIT_EVENT,
                                String.valueOf(permission));
                PushReporter.getInstance().reportEvent(YYPushStatisticEvent.REGISTER_FCM_TOKEN);
                //上报海度google play service事件
                PushReporter.getInstance().reportGooglePlayServiceToHiido(context);

                YYPushDeviceInfoHttp.getInstance().doReportThiradpartyTokenTask(context);
                //注册YYPush
                registerYYPush(context);

                //上报手机通知权限
                try {
                    NotificationManagerCompat manager =
                            NotificationManagerCompat.from(context.getApplicationContext());
                    Property property = new Property();
                    boolean flag = manager.areNotificationsEnabled();
                    PushLog.inst().log(TAG + ".asyncinitAllPush notificationPermission:" + flag);
                    property.putString("NotificationPermission", String.valueOf(flag));
                    PushReporter.getInstance()
                            .reportPermissionEventToHiido(
                                    YYPushConsts.HIIDO_NOTIFICATION_PERMISSION, Build.BRAND,
                                    property);
                } catch (Exception e) {
                    PushLog.inst().log(TAG + ".asyncinitAllPush exception:" + e);
                }


                //小米华为手机不使用JobScheduler和前台service
                if (!SystemUtil.isXiaoMi() && !SystemUtil.isHuaWei()) {
                    schedulerJob(context);

                    //设置前台Service
                    try {
                        if (Build.VERSION.SDK_INT < 24) {
                            context.startService(new Intent(context, ForegroundLiveService.class));
                        }
                    } catch (Exception e) {
                        PushLog.inst().log(TAG + ".asyncinitAllPush Exception:" + e);
                    }

                }

                // 开启定时获取离线消息的service
                setupFetchOutlineMsg(context);

                //注册极光push
                if (jgEnable) {
                    if (AppPackageUtil.getJiGuangAppKey(context) != null &&
                            TokenStore.getInstance().getJiGuangPushSwitch()) {
                        PushLog.inst().log(TAG + ".asyncinitAllPush init JiGuang Push SDK");
                        //设置极光心跳
                        initJguangHeart();
                        checkJiGuangComponentIsDisable(context);
                        JPushInterface.init(context);
                    } else {
                        PushLog.inst().log(TAG + ".asyncinitAllPush do not init JiGuang Push SDK");
                        disableJiGuangPushComponent(context);
                    }
                } else {
                    PushLog.inst().log(TAG + ".asyncinitAllPush do not init JiGuang Push SDK");
                    disableJiGuangPushComponent(context);
                }
                try {
                    if (!TextUtils.isEmpty(AppPushInfo.getFcmToken())) {
                        if (YYPushCallBackManager.getInstance().getPushTokenCallBack() != null) {
                            YYPushCallBackManager.getInstance().getPushTokenCallBack()
                                    .onSuccess(AppPushInfo.getFcmToken());
                        }
                    }
                    FirebaseInstanceId.getInstance().getInstanceId()
                            .addOnCompleteListener(new OnCompleteListener<InstanceIdResult>() {
                                @Override
                                public void onComplete(@NonNull Task<InstanceIdResult> task) {
                                    if (!task.isSuccessful()) {
                                        PushLog.inst().log(TAG +
                                                ".asyncinitAllPush getInstanceId failed:" +
                                                task.getException());
                                        Log.e(TAG, "onComplete task is not successful exception:" +
                                                task.getException());
                                        PushReporter.getInstance()
                                                .reportEvent(
                                                        YYPushStatisticEvent.REGISTER_FCM_TOKEN_FAILURE,
                                                        task.getException().getMessage());
                                        KLogW.i(YYPushStatisticEvent.REGISTER_FCM_TOKEN_FAILURE,
                                                task.getException().getMessage());
                                        return;
                                    }

                                    // Get new Instance ID token
                                    String refreshedToken = "";
                                    if (task.getResult() != null) {
                                        refreshedToken = task.getResult().getToken();
                                    }
                                    if (!TextUtils.isEmpty(refreshedToken)) {
                                        if (isJsonObject(refreshedToken)) {
                                            PushReporter.getInstance().newReportSucEvtToHiido(
                                                    YYPushConsts.HIIDO_FCM_TOKEN_CALLBACK_ISJSONOBJECT);
                                            JSONObject jsonObject;
                                            try {
                                                jsonObject = new JSONObject(refreshedToken);
                                                refreshedToken = jsonObject.getString("token");
                                            } catch (JSONException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                        PushLog.inst().log("YYPush.asyncinitAllPush Fcm Token:" +
                                                refreshedToken);
                                        if (!AppPushInfo.isDealFcmToken()) {
                                            AppPushInfo.setIsDealFcmToken();
                                            TokenStore.getInstance()
                                                    .dispatchToken(context,
                                                            ThirdPartyPushType.PUSH_TYPE_FCM,
                                                            refreshedToken);
                                            YYPushDeviceInfoHttp.getInstance()
                                                    .addThirdpartyToken(
                                                            ThirdPartyPushType.PUSH_TYPE_FCM,
                                                            refreshedToken);
                                        }
                                        String newFcmToken = "fcm:" + refreshedToken;
                                        if (YYPushCallBackManager.getInstance()
                                                .getPushTokenCallBack() != null) {
                                            YYPushCallBackManager.getInstance()
                                                    .getPushTokenCallBack()
                                                    .onSuccess(newFcmToken);
                                            PushLog.inst().log("YYPush.asyncinitAllPush, " +
                                                    "call IYYPushTokenCallback.onSuccess, "
                                                    + "token = " + newFcmToken);
                                        } else {
                                            Log.e(TAG, "onComplete callback is null");
                                        }
                                        PushReporter.getInstance()
                                                .reportEvent(
                                                        YYPushStatisticEvent.REGISTER_FCM_TOKEN_SUCCESS);
                                        PushReporter.getInstance()
                                                .newReportSucEvtToHiido(
                                                        YYPushConsts.HIIDO_FCM_TOKEN_RES_EVENT_ID);
                                    } else {
                                        PushReporter.getInstance()
                                                .newReportFailEvtToHiido(
                                                        YYPushConsts.HIIDO_FCM_TOKEN_RES_EVENT_ID,
                                                        YYPushConsts.RES_FAIL,
                                                        "task.getResult().getToken() is empty");
                                        PushReporter.getInstance()
                                                .reportEvent(
                                                        YYPushStatisticEvent.REGISTER_FCM_TOKEN_FAILURE,
                                                        "task.getResult().getToken() is empty");
                                        KLogW.i(YYPushStatisticEvent.REGISTER_FCM_TOKEN_FAILURE,
                                                "task.getResult().getToken() is empty");
                                    }
                                }
                            }).addOnFailureListener(new OnFailureListener() {
                        @Override
                        public void onFailure(@NonNull Exception e) {
                            Log.e(TAG, "onFailure: " + e);
                            PushLog.inst().log("YYPush.asyncinitAllPush onFailure exception:" + e);
                            PushReporter.getInstance()
                                    .newReportFailEvtToHiido(
                                            YYPushConsts.HIIDO_FCM_TOKEN_RES_EVENT_ID,
                                            YYPushConsts.RES_FAIL, e.getMessage());
                            PushReporter.getInstance().reportEvent(YYPushStatisticEvent
                                    .REGISTER_FCM_TOKEN_FAILURE, e.getMessage());
                            KLogW.i(YYPushStatisticEvent.REGISTER_FCM_TOKEN_FAILURE,
                                    e.getMessage());
                        }
                    });
                } catch (Exception e) {
                    PushLog.inst().log(TAG + ".asyncinitAllPush exception:" + e);
                }
                Set<String> checkSet = new HashSet<>();
                if (canUseXiaoMi()) {
                    if (isXMNetReceiverEnable) {
                        registerXiaoMiNetWorkChangeReceiver(context);
                    }
                    checkSet.add(ThirdPartyPushType.PUSH_TYPE_XIAOMI);
                    TokenRegisterState.getInstance().doStateCheck(checkSet, context);
                    //注册小米Push
                    PushLog.inst().log("YYPush.asyncinitAllPush, register xiaomi push sdk");
                    MiPushClient.registerPush(context, mXiaomiId, mXiaomiKey);
                    Property registeProperty = new Property();
                    registeProperty.putString("registerPushSdk", "Xiaomi");
                    PushReporter.getInstance().reportRegisterEventToHiido(
                            YYPushConsts.REGISTER_XIAOMI_PUSH_SDK_STATE);
                    PushReporter.getInstance()
                            .reportEvent(YYPushStatisticEvent.REGISTER_XIAOMI_TOKEN);
                }
                else if (canUseHuaWei(context)) {
                    checkSet.add(ThirdPartyPushType.PUSH_TYPE_HUAWEI);
                    TokenRegisterState.getInstance().doStateCheck(checkSet, context);
                    PushReporter.getInstance().reportRegisterEventToHiido(
                            YYPushConsts.REGISTER_HUAWEI_PUSH_SDK_STATE);
                    PushReporter.getInstance()
                            .reportEvent(YYPushStatisticEvent.REGISTER_HUAWEI_TOKEN);
                }else if(canUseOppo(context)){
                    try {
                        com.heytap.mcssdk.PushManager.getInstance().register(context,
                                AppPushInfo.getOpushAppkey(context),
                                AppPushInfo.getOpushAppSecret(context),
                                new PushOppoRegisterCallBack());

                        PushReporter.getInstance().reportRegisterEventToHiido(
                                YYPushConsts.REGISTER_OPPO_PUSH_SDK_STATE);
                        PushReporter.getInstance()
                                .reportEvent(YYPushStatisticEvent.REGISTER_OPPO_TOKEN);
                    } catch (Throwable e) {
                        PushLog.inst().log(TAG + "- register, failed:" + e);
                    }

                }

                JSONArray jsonArray = TokenStore.getInstance().getUnReportedStasticsFromDb(context);
                if (jsonArray != null) {
                    PushLog.inst().log(TAG +
                            ".asyncinitAllPush , db has reportStastics begin to call doReportStatisticsByHttp");
                    YYPushReportStatisticsHttp.getInstance()
                            .doReportStatisticsByHttp(context, jsonArray);
                } else {
                    PushLog.inst().log(TAG + ".asyncinitAllPush , db has no reportStastics");
                }

                registerNetWorkChangeReceiver(context);

                if (AppPushInfo.getIsNeedAccountSync()) {
                    // 设置账号同步
                    startAccountSync(context);
                }
            }
        });
    }

    private void setupFetchOutlineMsg(Context context) {
        // 开启定时获取离线消息的service
        try {
            int sysSdkVersion = AppPushInfo.getSDKVersion();
            boolean isEnableFetchOutlineMsg = AppPushInfo.isEnableFetchOutlineMsg();
            String curAppkey = "" + AppPushInfo.getYYKey(context);
            PushLog.inst().log(TAG+ ":" + curAppkey + ".asyncinitAllPush isEnableFetchOutlineMsg:" +
                    isEnableFetchOutlineMsg + ",sysSdkVer:" + sysSdkVersion);

            Map<String, String> property = new HashMap<String, String>() {{
                put("FetchOutlineMsgEnable", String.valueOf(isEnableFetchOutlineMsg));
            }};
            PushReporter.getInstance().reportFetchOutlieMsgEventToHiido(
                    YYPushConsts.HIIDO_FETCH_OUTLINE_MSG_ENABLE_EVENT_ID,
                    curAppkey,
                    property);

            // 当前5.0/5.1 有anr未查明,先做版本处理
            if (isEnableFetchOutlineMsg && sysSdkVersion > Build.VERSION_CODES.LOLLIPOP_MR1) {
                Intent remote = new Intent(context, FetchOutlineMsgService.class);
                remote.putExtra("isEnable", isEnableFetchOutlineMsg);
                remote.putExtra("pushTestIp", AppPushInfo.getPushTestEnvIp());
                remote.putExtra("isHttp", AppPushInfo.isUseHttpFetchOutlineMsg());
                context.startService(remote);
                context.startService(new Intent(context, FetchOutlineMsgLocalService.class));
            }
        } catch (Exception e) {
            PushLog.inst().log(TAG + ".asyncinitAllPush Exception:" + Log.getStackTraceString(e));
        }
    }

    private void startAccountSync(Context context) {
        try {
            AccountManager mAccountManager =
                    (AccountManager) context.getSystemService(ACCOUNT_SERVICE);
            PushLog.inst().log(TAG + ".startAccountSync account period:" +
                    AppPushInfo.getAccountSyncPeriod());

            String appName = context.getString(R.string.app_name);
            String packageName = context.getPackageName();
            if (!TextUtils.isEmpty(appName)) {
                if (!TextUtils.isEmpty(packageName)) {
                    Account account = new Account(context.getString(R.string.app_name),
                            context.getPackageName() + YYPushConsts.SYNC_ACCOUNT_TYPE_SUFFIX);

                    mAccountManager.addAccountExplicitly(account, null, null);
                    ContentResolver
                            .setIsSyncable(account,
                                    context.getPackageName() +
                                            YYPushConsts.ACCOUNT_CONTENT_AUTHORITY_SUFFIX,
                                    1);
                    ContentResolver
                            .setSyncAutomatically(account,
                                    context.getPackageName() +
                                            YYPushConsts.ACCOUNT_CONTENT_AUTHORITY_SUFFIX,
                                    true);
                    ContentResolver
                            .addPeriodicSync(account,
                                    context.getPackageName() +
                                            YYPushConsts.ACCOUNT_CONTENT_AUTHORITY_SUFFIX,
                                    new Bundle(), AppPushInfo.getAccountSyncPeriod());
                    PushReporter.getInstance()
                            .newReportSucEvtToHiido(YYPushConsts.HIIDO_ADD_ACCOUNT_EVENT_ID);
                }
            }
        } catch (Throwable e) {
            Log.e(TAG, "startAccountSync: " + e);
            PushReporter.getInstance()
                    .newReportFailEvtToHiido(YYPushConsts.HIIDO_ADD_ACCOUNT_EVENT_ID,
                            YYPushConsts.RES_FAIL, e.toString());
        }
    }

    private void disableJiGuangPushComponent(Context context) {
        PackageManager pm = context.getPackageManager();
        ComponentName componentName =
                new ComponentName(context, cn.jpush.android.service.PushService.class);
        pm.setComponentEnabledSetting(componentName,
                PackageManager.COMPONENT_ENABLED_STATE_DISABLED,
                PackageManager.DONT_KILL_APP);
        componentName = new ComponentName(context, DownloadProvider.class);
        pm.setComponentEnabledSetting(componentName,
                PackageManager.COMPONENT_ENABLED_STATE_DISABLED,
                PackageManager.DONT_KILL_APP);
        componentName = new ComponentName(context, DaemonService.class);
        pm.setComponentEnabledSetting(componentName,
                PackageManager.COMPONENT_ENABLED_STATE_DISABLED,
                PackageManager.DONT_KILL_APP);
        componentName = new ComponentName(context, OverseasWakedResultReceiver.class);
        pm.setComponentEnabledSetting(componentName,
                PackageManager.COMPONENT_ENABLED_STATE_DISABLED,
                PackageManager.DONT_KILL_APP);
    }

    private void checkJiGuangComponentIsDisable(Context context) {
        ComponentName componentName =
                new ComponentName(context, cn.jpush.android.service.PushService.class);
        PackageManager pm = context.getPackageManager();
        if (context.getPackageManager().getComponentEnabledSetting(componentName) ==
                PackageManager.COMPONENT_ENABLED_STATE_DISABLED) {
            pm.setComponentEnabledSetting(componentName,
                    PackageManager.COMPONENT_ENABLED_STATE_DEFAULT,
                    PackageManager.DONT_KILL_APP);
        }
        componentName = new ComponentName(context, cn.jpush.android.service.DownloadProvider.class);
        if (context.getPackageManager().getComponentEnabledSetting(componentName) ==
                PackageManager.COMPONENT_ENABLED_STATE_DISABLED) {
            pm.setComponentEnabledSetting(componentName,
                    PackageManager.COMPONENT_ENABLED_STATE_DEFAULT,
                    PackageManager.DONT_KILL_APP);
        }
        componentName = new ComponentName(context, DaemonService.class);
        if (context.getPackageManager().getComponentEnabledSetting(componentName) ==
                PackageManager.COMPONENT_ENABLED_STATE_DISABLED) {
            pm.setComponentEnabledSetting(componentName,
                    PackageManager.COMPONENT_ENABLED_STATE_DEFAULT,
                    PackageManager.DONT_KILL_APP);
        }
        componentName = new ComponentName(context, OverseasWakedResultReceiver.class);
        if (context.getPackageManager().getComponentEnabledSetting(componentName) ==
                PackageManager.COMPONENT_ENABLED_STATE_DISABLED) {
            pm.setComponentEnabledSetting(componentName,
                    PackageManager.COMPONENT_ENABLED_STATE_DEFAULT,
                    PackageManager.DONT_KILL_APP);
        }
    }

    private void registerYYPush(Context context) {
        YYTokenLoginHttp.getinstance().registerYYPush(context);
    }

    public Context getContext() {
        return mContext;
    }

    /***
     * 绑定uid和token接口
     * @param uid YY uid
     */
    public YYPushKitErrorCodes bindAccount(String uid) {
        if (mContext == null) {
            return YYPushKitErrorCodes.ERROR;
        }
        return YYTokenBindHttp.getinstance().bindAccount(mContext, uid);
    }

    /***
     * 解绑接口
     * @param uid YY uid
     */
    public YYPushKitErrorCodes unBindAccount(String uid) {
        return YYTokenUnBindHttp.getinstance().unBindAccount(mContext, uid);
    }

    /***
     * 设置标签
     * @param context android 上下文环境
     * @param tag 标签
     * @param append false不覆盖， true覆盖
     * @return
     */
    public YYPushKitErrorCodes setTag(Context context, JSONArray tag, boolean append) {
        return YYSetTagHttp.getInstance().setTag(context, tag, append);
    }

    /***
     * 删除标签
     * @param context android上下文环境
     * @param tag 标签
     * @return
     */
    public YYPushKitErrorCodes delTag(Context context, JSONArray tag) {
        return YYDelTagHttp.getInstance().delTag(context, tag);
    }

    /***
     * 上报FCM点击事件到海度和Push服务器
     * @param context application的context
     * @param msgId push消息的msgId
     * @param pushId push消息的pushId
     */
    public void uploadFcmClickEvtToHiido(Context context, long msgId, long pushId) {
        PushLog.inst().log(TAG + ".uploadFcmClickEvt msgid:" + msgId + ",pushid:" + pushId);
        TokenStore.getInstance()
                .uploadFcmReportStatistics(context, ThirdPartyPushType.PUSH_TYPE_FCM, msgId, pushId,
                        YYPushConsts.MSG_STATE_OPENED, false);
    }

    /***
     * 上报FCM未读消息点击事件到海度和Push服务器
     * @param context application的context
     * @param msgId push未读消息的msgId
     * @param pushId push未读消息的pushId
     */
    public void uploadFcmUnreadMsgClickEvtToHiido(Context context, long msgId, long pushId) {
        PushLog.inst().log(TAG + ".uploadFcmUnreadMsgClickEvtToHiido msgid:" + msgId + ",pushid:" +
                pushId);
        TokenStore.getInstance()
                .uploadFcmReportStatistics(context, ThirdPartyPushType.PUSH_TYPE_FCM, msgId, pushId,
                        YYPushConsts.MSG_STATE_OPENED, true);
    }

    /***
     * 业务上报自建通道push的点击到push服务器和hiido
     * @param context application的context
     * @param msgId push消息的msgId
     * @param pushId push消息的pushId
     */
    public void uploadYYPushClickEvt(Context context, long msgId, long pushId) {
        PushLog.inst().log(TAG + ".uploadYYPushClickEvt msgId:" + msgId + ", pushId:" + pushId);
    }

    /**
     * 设置是否启动自建通道长连接
     *
     * @param flag true 启动push自建通道长连接
     */
    public void isStartPushService(boolean flag) {
        Log.i(TAG, "isStartPushService:" + flag);
    }

    /***
     * 设置是否需要从push网关拉取未读消息（默认拉取）
     * @param flag true拉取，false不拉取
     */
    public void isNeedGetUnreadMsg(boolean flag) {
        Log.i(TAG, "isGetUnreadMsg: " + flag);
        AppPushInfo.setIsNeedGetUnreadMsg(flag);
    }

    /***
     * 设置每次拉取未读消息的最大数量
     * @param maxNum 消息数量
     */
    public void setGetUnreadMsgMaxNum(int maxNum) {
        Log.i(TAG, "setGetUnreadMsgMaxNum: " + maxNum);
        AppPushInfo.setGetUnreadMsgMaxNum(maxNum);
    }

    /***
     * 设置账号同步周期
     * @param period 同步周期间隔,单位秒
     */
    public void setAccountSyncPeriod(int period) {
        Log.i(TAG, "setAccountSyncPeriod: " + period);
        AppPushInfo.setAccountSyncPeriod(period);
    }

    /**
     * 设置获取离线消息, init之前调用
     *
     * @param enable
     */
    public void setFetchOutlineMsgEnable(boolean enable) {
        Log.i(TAG, "setFetchOutlineMsgEnable: " + enable);
        AppPushInfo.setEnableFetchOutlineMsg(enable);
    }

    public void setFetchOutlineUseHttp(boolean useHttp) {
        Log.i(TAG, "setFetchOutlineUseHttp: " + useHttp);
        AppPushInfo.setFetchOutlineUseHttp(useHttp);
    }

    /***
     * 设置是否开启账号同步
     * @param flag false不开启，true开启
     */

    public void isNeedAccountSync(boolean flag) {
        Log.i(TAG, "setIsNeedAccountSync: " + flag);
        AppPushInfo.setIsNeedAccountSync(flag);
    }

    /***
     * 业务设置线程池
     * @param executor
     */

    public void setPushTaskExecutor(IPushTaskExecutor executor) {
        ExecutorProvider.setPushTaskExecutor(executor);
    }

    private boolean canUseXiaoMi() {
        if (SystemUtil.isXiaoMi()) {
            if (SystemUtil.isMiUi() && (!TextUtils.isEmpty(mXiaomiId)) &&
                    (!TextUtils.isEmpty(mXiaomiKey)) &&
                    AppPushInfo.getUseXiaomi()) {
                return true;
            } else {
                PushReporter.getInstance()
                        .reportRegisterEventToHiido(
                                YYPushConsts.XIAOMI_NOT_REGISTER_XIAOMI_PUSH_SDK_STATE);
                return false;
            }
        } else {
            return false;
        }
    }

    private boolean canUseHuaWei(Context context) {
        if (SystemUtil.isHuaWei()) {
            PushReporter.getInstance().reportHmsVersionEventToHiido(context);
            if (isSupportHms(context) && AppPushInfo.getUseHuawei()) {
                return true;
            } else {
                PushReporter.getInstance()
                        .reportRegisterEventToHiido(context,
                                YYPushConsts.HUAWEI_NOT_REGISTER_HUAWEI_PUSH_SDK_STATE);
                return false;
            }
        } else {
            return false;
        }
    }

    private boolean canUseOppo(Context context){
        try {
            String appKey = AppPushInfo.getOpushAppkey(context);
            String appSecret = AppPushInfo.getOpushAppSecret(context);
            boolean v = SystemUtil.isOppo()
                    && com.heytap.mcssdk.PushManager.isSupportPush(context)
                    && !StringUtil.isNullOrEmpty(appKey)
                    && !StringUtil.isNullOrEmpty(appSecret);
            PushLog.inst().log(TAG + ".isSupportOpush:" + v +
                    ",appKey:" + appKey +
                    ",appSecret:" + appSecret);
            if (!v) {
                PushReporter.getInstance()
                        .reportRegisterEventToHiido(context,
                                YYPushConsts.OPPO_NOT_REGISTER_XIAOMI_PUSH_SDK_STATE);
            }
            return v;
        } catch (Exception e) {
            PushLog.inst().log(TAG + ".isSupportOpush exception:" + Log.getStackTraceString(e));
            return false;
        }
    }

    private void setLogPathToFile(String dir) {
        FileWriter writer = null;
        try {
            String filePath = PushFileHelper.instance().getPushLogConfigFilePath();

            File logTmpFile = new File(filePath);

            if (dir == null) {
                dir = "";
            }
            writer = new FileWriter(logTmpFile);
            writer.write(dir);
            writer.flush();

            AppInfo.instance().setLogPath(dir);
        } catch (Exception e) {
            Log.e("YYPush", "setLogPathToFile exception:" + e.getMessage());
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean isSupportHms(Context context) {
        return HuaweiApiAvailability.getInstance().isHuaweiMobileServicesAvailable(context) == 0;
    }

    /***
     * 提供接口给客户端，用来设置push测试环境ip
     * @param ip
     */
    public void setPushTestEnvIp(String ip) {
        AppPushInfo.setPushTestEnvIp(ip);
    }

    private boolean isJsonObject(String content) {
        try {
            JSONObject jsonObject = new JSONObject(content);
            if (jsonObject.has("token")) {
                PushLog.inst().log("YYPush.isJsonObject getToken from fcm , token:" +
                        jsonObject.getString("token"));
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            PushLog.inst().log("YYPush.isJsonObject exception:" + e);
            return false;
        }
    }

    private void schedulerJob(Context context) {
        try {
            PushLog.inst()
                    .log(TAG + ".schedulerJob mIsUseJobSchedulerFlag = " + mIsUseJobSchedulerFlag);
            if (mIsUseJobSchedulerFlag && Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                ComponentName mServiceComponent =
                        new ComponentName(context, KeepLiveJobService.class);
                JobInfo.Builder builder;
                JobScheduler tm =
                        (JobScheduler) context.getSystemService(context.JOB_SCHEDULER_SERVICE);
                long delay = 1;
                schedulerHour.add(10);
                schedulerHour.add(14);
                schedulerHour.add(18);
                schedulerHour.add(22);
                for (Integer num : schedulerHour) {
                    builder = new JobInfo.Builder(mJobId++, mServiceComponent);
                    delay = calculateSchedulerDelay(num, schedulerMinute) * 60;
                    builder.setMinimumLatency(delay * 1000);
                    builder.setOverrideDeadline((delay + 150) * 1000);
                    builder.setRequiredNetworkType(JobInfo.NETWORK_TYPE_ANY);
                    builder.setRequiresDeviceIdle(false);
                    builder.setRequiresCharging(false);
                    // Schedule job
                    if (tm != null) {
                        tm.schedule(builder.build());
                    }
                }
            }
        } catch (Exception e) {
            PushLog.inst().log("PushMgr.schedulerJob exception:" + e);
        }
    }

    private long calculateSchedulerDelay(int mSchedulerHour, int mSchedulerMinute) {
        long delay;
        Time t = new Time();
        t.setToNow();
        int currentHour = t.hour;
        int currentMinute = t.minute;
        int mTempHour = mSchedulerHour;
        int mTempMinute = mSchedulerMinute + 30;
        Random random = new Random();
        int mCalcMinute = random.nextInt(mTempMinute) % (mTempMinute - mSchedulerMinute + 1) +
                mSchedulerMinute;
        mSchedulerHour = (mCalcMinute >= 60 ? ((mTempHour + 1) % 24) : mTempHour);
        mSchedulerMinute = mCalcMinute % 60;
        Log.i(TAG, "calculateSchedulerDelay: currentHour:" + currentHour + ", currentMinute:" +
                currentMinute +
                ", schedulerHour:" + mSchedulerHour + ", schedulerMinute:" + mSchedulerMinute);
        PushLog.inst()
                .log("currentHour = " + currentHour + ", currentMinute = " + currentMinute +
                        ", schedulerHour = " +
                        mSchedulerHour + ", schedulerMinute = " + mSchedulerMinute);
        if (currentHour >= 0 && currentHour < mSchedulerHour) {
            delay = (mSchedulerHour - currentHour) * 60 - currentMinute + mSchedulerMinute;
        } else if (currentHour == mSchedulerHour) {
            if (currentMinute < mSchedulerMinute) {
                delay = mSchedulerMinute - currentMinute;
            } else {
                delay = (24 - currentHour) * 60 - currentMinute + mSchedulerHour * 60 +
                        mSchedulerMinute;
            }
        } else {
            delay = (24 - currentHour) * 60 - currentMinute + mSchedulerHour * 60 +
                    mSchedulerMinute;
        }
        return delay;
    }

    private void registerNetWorkChangeReceiver(Context context) {
        try {
            PushLog.inst().log(TAG + ".registerNetWorkChangeReceiver");
            context.registerReceiver(new NetworkChangeReceiver(),
                    new IntentFilter(YYPushConsts.NETWORK_CHANGE_ACTION));
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ".registerNetWorkChangeReceiver//erro=" + t);
        }
    }

    private void registerXiaoMiNetWorkChangeReceiver(Context context) {
        try {
            PushLog.inst().log(TAG + ".registerXiaoMiNetWorkChangeReceiver");
            context.registerReceiver(new NetworkStatusReceiver(),
                    new IntentFilter(YYPushConsts.NETWORK_CHANGE_ACTION));
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ".registerXiaoMiNetWorkChangeReceiver//erro=" + t);
        }
    }

    public boolean isXMNetReceiverEnable() {
        return isXMNetReceiverEnable;
    }

    public void setXMNetReceiverEnable(boolean XMNetReceiverEnable) {
        isXMNetReceiverEnable = XMNetReceiverEnable;
    }

    public boolean getIsForground() {
        return ActivityLifecycleHelper.isForground();
    }

    private void onAppCreate(Context context) {
        if (!isAppCreate) {
            ActivityLifecycleHelper.setActivityLifecycleCallback(context);
        }
        isAppCreate = true;
    }

    public boolean isJgEnable() {
        return jgEnable;
    }

    public void setJgEnable(boolean jgEnable) {
        try {
            this.jgEnable = jgEnable;
            if (!jgEnable && mContext != null) {
                PushLog.inst().log(TAG + ".asyncinitAllPush do not init JiGuang Push SDK");
                disableJiGuangPushComponent(mContext);
            }
            Property property = new Property();
            property.putString("jgEnable", String.valueOf(jgEnable));
            PushReporter.getInstance()
                    .reportNotificationEventToHiido(
                            YYPushConsts.HIIDO_JIGUANG_ENABLE,
                            "jgEnable", property);
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",setJgEnable ,erro =" + t);
        }
    }

    private void createNotificationChannel() {
//         Create the NotificationChannel, but only on API 26+ because
//         the NotificationChannel class is new and not in the support library
         if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
             CharSequence name = getContext().getString(R.string.channel_name);
             String description = getContext().getString(R.string.channel_description);
             int importance = NotificationManager.IMPORTANCE_DEFAULT;
             int appkey = AppPushInfo.getYYKey(getContext());
             NotificationChannel
                     channel = new NotificationChannel(String.valueOf(appkey), name, importance);
             channel.setDescription(description);
             // Register the channel with the system; you can't change the importance
             // or other notification behaviors after this
             NotificationManager notificationManager = getContext().getSystemService(NotificationManager.class);
             notificationManager.createNotificationChannel(channel);
         }
    }

    public boolean isSuspendStrategyEnable() {
        return suspendStrategyEnable;
    }

    public void setSuspendStrategyEnable(boolean suspendStrategyEnable) {
        this.suspendStrategyEnable = suspendStrategyEnable;
    }

    private boolean lockReshow = false;

    public boolean isLockReshow() {
        return lockReshow;
    }

    /**
     * 是否开启锁屏重弹功能
     * @param lockReshow ,true开启锁屏重弹
     */
    public void setLockReshow(boolean lockReshow) {
        this.lockReshow = lockReshow;
    }
}
