package com.yy.pushsvc;

import android.content.Context;

import com.yy.pushsvc.util.NotificationUtil;
import com.yy.pushsvc.util.PushLog;

import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * Created by GuanYuFeng
 * on 2020/4/10
 */
public class NotificationCounter {
    private static final String TAG = "NotificationCounter";
    private static final int MAX_NOTIFICATION_COUNT = 3;//hago最多显示3条通知
    private static volatile NotificationCounter instance;
    private ConcurrentLinkedQueue<String> notificationCache = new ConcurrentLinkedQueue<>();
    private int mMaxCount = MAX_NOTIFICATION_COUNT;

    public static NotificationCounter getInstance() {
        if (instance == null) {
            synchronized (NotificationCounter.class) {
                if (instance == null) {
                    instance = new NotificationCounter();
                }
            }
        }
        return instance;
    }

    public void addNotificationCache(Context context, int notificationId,int maxCount) {
        try {
            if (maxCount < 1) {
                maxCount =  mMaxCount;
            }
            if (notificationCache.size() == maxCount) {
                String nid = notificationCache.poll();
                NotificationUtil.cancleNotification(context, Integer.valueOf(nid));
            }
            notificationCache.add(notificationId + "");
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",addNotificationCache,erro" + t);
        }
    }

    public void onCancelNotification(int notificationId) {
        try {
            notificationCache.remove(notificationId + "");
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",addNotificationCache,erro" + t);
        }
    }
}
