package com.yy.pushsvc;

import android.content.Context;

import org.json.JSONArray;

import java.util.Map;

/**
 * Created by ${GuanYuFeng}
 * on 2019/8/12
 */
public interface IMsgArriveCallback {
     int NOTIFICATION_TEMPLATE_TYPE =  1;
     int NOTIFICATION_LOCK_TYPE =  2;
     int NOTIFICATION_SUSPEND_TYPE =  3;

    // override this method to receiver token change.
    void onTokenReceived(String type, byte[] token, boolean isThirdPartyToken, Context ctx);

    /**
     * @param msgId
     * @param msgBody
     * @param channelType
     * @param ctx
     * @param msgData  直接使用firebase平台下发送消息时，配置的键值对
     */
    void onPushMessageReceived(long msgId, byte[] msgBody, String channelType, Context ctx, Map<String,
            String> msgData);

    // override this method to receiver unreg app res.
    void onAppBindRes(int resCode, String account, Context ctx);

    // override this method to receiver unreg app res.
    void onAppUnbindRes(int resCode, String account, Context ctx);

    void onNotificationArrived(long msgID, byte[] payload, String channelType, Context ctx);

    void onNotificationClicked(long msgID, byte[] payload, String channelType, Context ctx);

    void onSetTagRes(int resCode, Context ctx);

    void onDelTagRes(int resCode, Context ctx);

    void onPushUnreadMsgReceived(Context context, String channelType, JSONArray msgJsonArray);

    /**
     * @param msgID
     * @param payload
     * @param channelType
     * @param type 1.普通自定义样式push；2.锁屏push；3.悬浮窗push
     * @param ctx
     */
    void onPushSDKNotificationShow(long msgID, byte[] payload, String channelType,int type ,  Context ctx);

    void onPushSDKNotificationArrived(long msgId, byte[] msgBody, String channelType
            , Context ctx);

    void onPushSDKNotificationReShow(long msgID, byte[] payload, String channelType,  Context ctx);

}
