package com.yy.pushsvc;

import android.content.Context;
import android.content.Intent;

import com.yy.pushsvc.util.PushLog;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.Map;

/**
 * Created by GuanYuFeng
 * on 2019/11/8
 */
public abstract class BaseMsgArriveCallback implements IMsgArriveCallback {
    private static final String TAG = "BaseMsgArriveCallback";

    @Override
    public void onTokenReceived(String type, byte[] token, boolean isThirdPartyToken, Context ctx) {
        PushLog.inst().log(TAG + ",onTokenReceived,type=" + type + ",token=" + new String(token));
    }

    @Override
    public void onAppBindRes(int resCode, String account, Context ctx) {
        PushLog.inst().log(TAG + ",onAppBindRes,account=" + account);
    }

    @Override
    public void onAppUnbindRes(int resCode, String account, Context ctx) {
        PushLog.inst().log(TAG + ",onAppUnbindRes,account=" + account);
    }

    @Override
    public void onSetTagRes(int resCode, Context ctx) {
        PushLog.inst().log(TAG + ",onSetTagRes,resCode=" + resCode);
    }

    @Override
    public void onDelTagRes(int resCode, Context ctx) {
        PushLog.inst().log(TAG + ",onDelTagRes,resCode=" + resCode);
    }

    @Override
    public void onNotificationArrived(long msgID, byte[] payload, String channelType, Context ctx) {
        PushLog.inst().log(TAG + ",onNotificationArrived,payload=" + new String(payload));
    }

    @Override
    public void onPushUnreadMsgReceived(Context context, String channelType,
                                        JSONArray msgJsonArray) {
        PushLog.inst().log(TAG + ",onPushUnreadMsgReceived,payload=" + msgJsonArray.toString());
        for (int i = 0; i < msgJsonArray.length(); ++i) {
            try {
                JSONObject jsonObject = (JSONObject) msgJsonArray.get(i);
                long msgId = jsonObject.getLong("msgid");
                String payload = jsonObject.getString("payload");
                long pushId = jsonObject.getLong("pushid");
                onPushMessageReceived(msgId, payload.getBytes(), channelType, context, null);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onPushMessageReceived(long msgId, byte[] msgBody, String channelType, Context ctx,
                                      Map<String, String> msgData) {
        PushLog.inst().log(TAG + ",onPushMessageReceived,msgBody=" + new String(msgBody));
    }

    @Override
    public void onNotificationClicked(long msgID, byte[] payload, String channelType, Context ctx) {
        PushLog.inst().log(TAG + ",onNotificationClicked,payload=" + new String(payload));
    }

    /**
     * 点击厂商后跳转activity，仅供参考
     */
    public void startClickActivity(long msgID, byte[] payload, Context ctx, Class act) {
        Intent in = new Intent(ctx, act);
        in.putExtra("payload", new String(payload));
        in.putExtra("msgid", msgID + "");
        in.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
        in.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        in.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        ctx.startActivity(in);
    }
}
