package com.yy.pushglide;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;

/**
 * author：guojunjie
 * create：2017/3/22  10:42
 * description：实现圆角 图片的裁剪 结合 glide 加载框架
 */

public class RoundTransform {
    private float radius = 0f;

    /**
     * 构造函数
     * @param dp      圆角半径
     */
    public RoundTransform( int dp) {
        radius = Resources.getSystem().getDisplayMetrics().density * dp;
    }

    public Bitmap transform(PushBitmapPool pool, Bitmap toTransform) {
        return roundCrop(pool, toTransform);
    }

    public String getId() {
        return getClass().getName() + Math.round(radius);
    }

    private Bitmap roundCrop(PushBitmapPool pool, Bitmap source) {
        if (source == null) {
            return null;
        }
        Bitmap result = pool.get(source.getWidth(), source.getHeight(), Bitmap.Config.ARGB_8888);
        if (result == null) {
            result = Bitmap.createBitmap(source.getWidth(), source.getHeight(),
                    Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(result);
        Paint paint = new Paint();
        paint.setShader(
                new BitmapShader(source, BitmapShader.TileMode.CLAMP, BitmapShader.TileMode.CLAMP));
        paint.setAntiAlias(true);
        RectF rectF = new RectF(0f, 0f, source.getWidth(), source.getHeight());
        canvas.drawRoundRect(rectF, radius, radius, paint);
        return result;
    }

}
