/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audioengine;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioAttributes;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Process;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import org.json.JSONArray;
import org.json.JSONObject;
import org.webrtc.audioengine.UploadESampleThread;

class AudioManagerAndroid {
    private static final int DEFAULT_SAMPLING_RATE = 44100;
    private static final int DEFAULT_FRAMES_PER_BUFFER = 256;
    private int mNativeOutputSampleRate;
    private boolean mAudioLowLatencySupported;
    private int mAudioLowLatencyOutputFrameSize;
    private static final String TAG = "AudioManagerAndroid";
    private final Context mContext;
    private final AudioManager mAudioManager;
    private final String bluetoothHeadsetIntent;
    private final String scoAudioStateIntent;
    private PhoneStateListener mPhoneStateListener = null;
    private boolean initialized = false;
    private String mModel = null;
    AudioManager.OnAudioFocusChangeListener mAudioFocusChangeListener;
    AudioFocusRequest mAudioFocusRequest;
    private Boolean mIsAbandonAudioFocus = false;
    private boolean mIsHeadsetPlugReceiverRegistered = false;
    private BroadcastReceiver mHeadsetPlugReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.hasExtra("state")) {
                int state = intent.getIntExtra("state", 0);
                AudioManagerAndroid.this.nativeNotifyHeadsetPlug(state);
                if (state == 0) {
                    Log.i((String)AudioManagerAndroid.TAG, (String)"headset not connected");
                } else if (state == 1) {
                    Log.i((String)AudioManagerAndroid.TAG, (String)"headset connected");
                }
            }
        }
    };
    private boolean BluetoothReceiverRegistered = false;
    private BroadcastReceiver BluetoothReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals(AudioManagerAndroid.this.bluetoothHeadsetIntent)) {
                int bluetoothHeadsetState = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                if (bluetoothHeadsetState == 2) {
                    AudioManagerAndroid.this.nativeNotifyBluetoothPlug(1);
                } else if (bluetoothHeadsetState == 0) {
                    AudioManagerAndroid.this.nativeNotifyBluetoothPlug(0);
                }
            }
        }
    };
    private boolean mPhoneStateListenerRegistered = false;
    private static Context mCtx;
    String url = "http://do.yy.duowan.com/dynamic-shunt-data/type2/109/AudioengineConfig";
    String filename = "AudioengineConfig";
    private static String filesDir;
    private int[] config = new int[]{-128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, 0};

    private AudioManagerAndroid(Context context) {
        AudioManager audioManager;
        this.mContext = context;
        this.bluetoothHeadsetIntent = "android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED";
        this.scoAudioStateIntent = Build.VERSION.SDK_INT >= 14 ? "android.media.ACTION_SCO_AUDIO_STATE_UPDATED" : "android.media.SCO_AUDIO_STATE_CHANGED";
        this.mAudioManager = audioManager = (AudioManager)context.getSystemService("audio");
        this.mNativeOutputSampleRate = 44100;
        this.mAudioLowLatencyOutputFrameSize = 256;
        if (Build.VERSION.SDK_INT >= 17) {
            String framesPerBuffer;
            String sampleRateString = audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            if (sampleRateString != null) {
                this.mNativeOutputSampleRate = Integer.parseInt(sampleRateString);
            }
            if ((framesPerBuffer = audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER")) != null) {
                this.mAudioLowLatencyOutputFrameSize = Integer.parseInt(framesPerBuffer);
            }
        }
        this.mModel = Build.BRAND.toLowerCase() + "-" + Build.MODEL.toLowerCase();
        try {
            this.mAudioLowLatencySupported = context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
        }
        catch (RuntimeException e) {
            this.mAudioLowLatencySupported = false;
        }
        AudioManagerAndroid.DoLog("AudioManagerAndroid low latency supported " + this.mAudioLowLatencySupported + " >> " + this.mAudioLowLatencyOutputFrameSize);
    }

    private void init(Context context) {
        if (this.initialized) {
            return;
        }
        Log.d((String)TAG, (String)("audio mode is: " + this.mAudioManager.getMode()));
        this.initialized = true;
    }

    private int getNativeOutputSampleRate() {
        return this.mNativeOutputSampleRate;
    }

    private boolean isAudioLowLatencySupported() {
        return this.mAudioLowLatencySupported;
    }

    private int getAudioLowLatencyOutputFrameSize() {
        return this.mAudioLowLatencyOutputFrameSize;
    }

    private static int getAudioTrackMiniBufferSize(int sampleRate, int channelCount) {
        int channelMode = 4;
        if (channelCount == 2) {
            channelMode = 12;
        }
        int minBufferSizeInBytes = AudioTrack.getMinBufferSize((int)sampleRate, (int)channelMode, (int)2);
        return minBufferSizeInBytes;
    }

    private static int getMode(Context context) {
        int result = 0;
        try {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            result = audioManager.getMode();
            return result;
        }
        catch (Exception e) {
            AudioManagerAndroid.DoLog("AudioManagerAndroid getMode error");
        }
        finally {
            return result;
        }
    }

    private static int isSpeakerphoneOn(Context context) {
        int result = 0;
        try {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            result = audioManager.isSpeakerphoneOn() ? 1 : 0;
            return result;
        }
        catch (Exception e) {
            AudioManagerAndroid.DoLog("AudioManagerAndroid isSpeakerphoneOn error");
        }
        finally {
            return result;
        }
    }

    private static int isHeadsetPlugin(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        return audioManager.isWiredHeadsetOn() ? 1 : 0;
    }

    private static void setMode(Context context, int mode) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        audioManager.setMode(mode);
        AudioManagerAndroid.DoLog("AudioManagerAndroid setMode: " + audioManager.getMode());
    }

    private static void setSpeakerphoneOn(Context context, boolean on) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        audioManager.setSpeakerphoneOn(on);
        AudioManagerAndroid.DoLog("AudioManagerAndroid setSpeakerphoneOn: " + String.valueOf(on));
    }

    public static void DoLog(String msg) {
        AudioManagerAndroid.nativeLogDebugInfo(msg);
    }

    private void SetNotify(int notify) {
        if (notify == 1) {
            this.registerBluetoothReceiver();
            this.registerHeadsetPlugReceiver();
            this.registerPhoneStateListener();
        } else {
            this.unregisterBluetoothReceiver();
            this.unRegisterHeadsetPlugReceiver();
            this.unRegisterPhoneStateListener();
        }
    }

    private void registerHeadsetPlugReceiver() {
        Log.i((String)TAG, (String)"registerHeadsetPlugReceiver");
        if (!this.mIsHeadsetPlugReceiverRegistered) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.HEADSET_PLUG");
            this.mContext.registerReceiver(this.mHeadsetPlugReceiver, intentFilter);
            this.mIsHeadsetPlugReceiverRegistered = true;
        }
    }

    private void unRegisterHeadsetPlugReceiver() {
        Log.i((String)TAG, (String)"unRegisterHeadsetPlugReceiver");
        if (this.mIsHeadsetPlugReceiverRegistered) {
            this.mContext.unregisterReceiver(this.mHeadsetPlugReceiver);
            this.mIsHeadsetPlugReceiverRegistered = false;
        }
    }

    @TargetApi(value=14)
    public boolean isBluetoothHeadsetConnected() {
        try {
            int BluetoothStatus_hdset;
            BluetoothAdapter BTAdapter = BluetoothAdapter.getDefaultAdapter();
            if (BTAdapter == null) {
                return false;
            }
            if (!this.mAudioManager.isBluetoothScoAvailableOffCall()) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 14 ? 2 == (BluetoothStatus_hdset = BTAdapter.getProfileConnectionState(1)) : !BluetoothAdapter.getDefaultAdapter().getBondedDevices().isEmpty()) {
                return true;
            }
        }
        catch (Exception ex) {
            Log.w((String)TAG, (String)"detect bluetooth error", (Throwable)ex);
        }
        return false;
    }

    private boolean hasPermission(Context context, String permission2) {
        return context.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    private void registerBluetoothReceiver() {
        Log.v((String)TAG, (String)"registerBluetoothReceiver()");
        if (!this.hasPermission(this.mContext, "android.permission.BLUETOOTH") || !this.hasPermission(this.mContext, "android.permission.BLUETOOTH_ADMIN")) {
            return;
        }
        try {
            if (!this.BluetoothReceiverRegistered) {
                this.mContext.registerReceiver(this.BluetoothReceiver, new IntentFilter(this.bluetoothHeadsetIntent));
                this.BluetoothReceiverRegistered = true;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"registerBluetoothReceiver error");
        }
        if (this.isBluetoothHeadsetConnected()) {
            this.nativeNotifyBluetoothPlug(1);
        } else {
            this.nativeNotifyBluetoothPlug(0);
        }
    }

    private void unregisterBluetoothReceiver() {
        if (!this.hasPermission(this.mContext, "android.permission.BLUETOOTH") || !this.hasPermission(this.mContext, "android.permission.BLUETOOTH_ADMIN")) {
            return;
        }
        if (this.BluetoothReceiverRegistered) {
            this.mContext.unregisterReceiver(this.BluetoothReceiver);
            this.BluetoothReceiverRegistered = false;
        }
    }

    private void registerPhoneStateListener() {
        if (this.mPhoneStateListener == null) {
            try {
                this.mPhoneStateListenerRegistered = true;
                this.mPhoneStateListener = new MediaPhoneStateListener();
                this.listenTelState(32);
            }
            catch (Exception var1) {
                AudioManagerAndroid.DoLog("MediaPhoneStateListener: Error, can't listen...");
            }
        }
    }

    private void unRegisterPhoneStateListener() {
        if (this.mPhoneStateListener != null) {
            this.mPhoneStateListener = null;
            this.mPhoneStateListenerRegistered = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAudioFocusListener() {
        if (this.mAudioFocusChangeListener != null) {
            return;
        }
        this.mAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onAudioFocusChange(int focusChange) {
                Boolean bl = AudioManagerAndroid.this.mIsAbandonAudioFocus;
                synchronized (bl) {
                    if (!AudioManagerAndroid.this.mIsAbandonAudioFocus.booleanValue()) {
                        AudioManagerAndroid.DoLog("AudioManagerAndroid  onAudioFocusChange " + focusChange);
                        AudioManagerAndroid.this.nativeNotifyPhoneAudioFocusChanged(focusChange);
                    } else {
                        Log.e((String)AudioManagerAndroid.TAG, (String)("  receive onAudioFocusChange after abandon audio focus " + focusChange));
                    }
                }
            }
        };
        if (Build.VERSION.SDK_INT >= 26) {
            AudioAttributes audioAttributes = new AudioAttributes.Builder().setContentType(2).setUsage(1).setLegacyStreamType(3).build();
            this.mAudioFocusRequest = new AudioFocusRequest.Builder(1).setAudioAttributes(audioAttributes).setOnAudioFocusChangeListener(this.mAudioFocusChangeListener, new Handler()).build();
            int result = this.mAudioManager.requestAudioFocus(this.mAudioFocusRequest);
            if (result == 1) {
                this.nativeNotifyPhoneAudioFocusChanged(1);
            }
            AudioManagerAndroid.DoLog("AudioManagerAndroid requestAudioFocus26 " + result);
        } else if (Build.VERSION.SDK_INT >= 8) {
            int result = this.mAudioManager.requestAudioFocus(this.mAudioFocusChangeListener, 3, 1);
            if (result == 1) {
                this.nativeNotifyPhoneAudioFocusChanged(1);
            }
            AudioManagerAndroid.DoLog("AudioManagerAndroid requestAudioFocus8 " + result);
        }
        Boolean bl = this.mIsAbandonAudioFocus;
        synchronized (bl) {
            this.mIsAbandonAudioFocus = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAudioFocusListener() {
        int result = 0;
        if (Build.VERSION.SDK_INT >= 26) {
            if (this.mAudioFocusRequest != null) {
                result = this.mAudioManager.abandonAudioFocusRequest(this.mAudioFocusRequest);
                this.mAudioFocusRequest = null;
                this.mAudioFocusChangeListener = null;
            }
        } else if (Build.VERSION.SDK_INT >= 8 && this.mAudioFocusChangeListener != null) {
            result = this.mAudioManager.abandonAudioFocus(this.mAudioFocusChangeListener);
            this.mAudioFocusChangeListener = null;
        }
        Boolean bl = this.mIsAbandonAudioFocus;
        synchronized (bl) {
            this.mIsAbandonAudioFocus = true;
        }
        AudioManagerAndroid.DoLog("AudioManagerAndroid abandonAudioFocus " + result);
    }

    private void listenTelState(int what) {
        ((TelephonyManager)this.mContext.getSystemService("phone")).listen(this.mPhoneStateListener, what);
    }

    private static void setBluetoothScoOn(Context context, int on) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        audioManager.setBluetoothScoOn(on > 0);
        AudioManagerAndroid.DoLog("AudioManagerAndroid setBluetoothScoOn: " + on);
    }

    private static void startOrStopBluetoothSco(Context context, int start) {
        try {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            if (start > 0) {
                audioManager.startBluetoothSco();
            } else {
                audioManager.stopBluetoothSco();
            }
            AudioManagerAndroid.DoLog("AudioManagerAndroid startOrStopBluetoothSco: " + start);
        }
        catch (Exception ex) {
            AudioManagerAndroid.DoLog("AudioManagerAndroid startOrStopBluetoothSco exception: " + ex);
        }
    }

    private static int getAndroidOSVersion() {
        return Build.VERSION.SDK_INT;
    }

    private native void nativeNotifyHeadsetPlug(int var1);

    private native void nativeNotifyBluetoothPlug(int var1);

    private native void nativeNotifyPhoneCallReceive(int var1);

    private static native void nativeLogDebugInfo(String var0);

    private native void nativeNotifyPhoneAudioFocusChanged(int var1);

    public int[] AsyncLoad(Context ctx) throws InterruptedException {
        mCtx = ctx;
        try {
            filesDir = ctx.getFilesDir().getAbsolutePath();
        }
        catch (Exception e) {
            AudioManagerAndroid.DoLog("AudioEngineConfig AsyncLoad bug");
        }
        LoadThread lt = new LoadThread();
        Thread th = new Thread(lt);
        th.start();
        th.join();
        AudioManagerAndroid.DoLog("AudioEngineConfig Param:" + this.mModel + ":" + Arrays.toString(this.config));
        return this.config;
    }

    static boolean InToday(long ts) {
        Calendar ca = Calendar.getInstance();
        ca.set(11, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        ca.set(14, 0);
        return ts > ca.getTimeInMillis();
    }

    static String get(String url) throws Exception {
        String lines;
        URL getUrl = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)getUrl.openConnection();
        connection.connect();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((lines = reader.readLine()) != null) {
            sb.append(lines);
        }
        reader.close();
        connection.disconnect();
        return sb.toString();
    }

    public static void UploadRecordFile() {
        String Imei = Build.SERIAL;
        Log.d((String)"Audio", (String)("uploaddata SERIAL " + Imei));
        new UploadESampleThread(Environment.getExternalStorageDirectory().getPath() + "/yysdk/logs/audiorec/", Imei).start();
    }

    static /* synthetic */ int[] access$902(AudioManagerAndroid x0, int[] x1) {
        x0.config = x1;
        return x1;
    }

    class LoadThread
    implements Runnable {
        LoadThread() {
        }

        @Override
        public void run() {
            try {
                JSONObject js = this.getJsonConfig();
                if (js.has(AudioManagerAndroid.this.mModel)) {
                    Log.d((String)"Audio", (String)"AudioEngineConfig get json has mode");
                    JSONArray aecfarray = js.getJSONArray(AudioManagerAndroid.this.mModel);
                    AudioManagerAndroid.access$902(AudioManagerAndroid.this, new int[aecfarray.length()]);
                    for (int i = 0; i < aecfarray.length(); ++i) {
                        ((AudioManagerAndroid)AudioManagerAndroid.this).config[i] = aecfarray.getInt(i);
                    }
                    AudioManagerAndroid.DoLog("AudioEngineConfig get json model in" + Arrays.toString(AudioManagerAndroid.this.config));
                } else if (js.has("default")) {
                    JSONArray aecfarray = js.getJSONArray("default");
                    AudioManagerAndroid.access$902(AudioManagerAndroid.this, new int[aecfarray.length()]);
                    for (int i = 0; i < aecfarray.length(); ++i) {
                        ((AudioManagerAndroid)AudioManagerAndroid.this).config[i] = aecfarray.getInt(i);
                    }
                    AudioManagerAndroid.DoLog("AudioEngineConfig Param get default mode :" + Arrays.toString(AudioManagerAndroid.this.config));
                }
            }
            catch (Exception e) {
                AudioManagerAndroid.DoLog("AudioEngineConfig Param Load Error " + e.getMessage());
            }
        }

        JSONObject getJsonConfig() {
            try {
                int tl;
                File aecf = new File(filesDir + "/" + AudioManagerAndroid.this.filename);
                if (!aecf.exists() || !AudioManagerAndroid.InToday(aecf.lastModified())) {
                    try {
                        String str = AudioManagerAndroid.get(AudioManagerAndroid.this.url);
                        JSONObject js = new JSONObject(str);
                        FileWriter fw = new FileWriter(aecf);
                        fw.write(str);
                        fw.close();
                        AudioManagerAndroid.DoLog("AudioEngineConfig get json finish");
                        return js;
                    }
                    catch (Exception e) {
                        AudioManagerAndroid.DoLog("AudioEngineConfig getJsonConfig fail " + e.getMessage());
                    }
                }
                FileInputStream fi = new FileInputStream(aecf);
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((tl = fi.read(buf, 0, 1024)) > 0) {
                    bo.write(buf, 0, tl);
                }
                fi.close();
                String str = bo.toString();
                JSONObject js = new JSONObject(str);
                return js;
            }
            catch (Exception e) {
                AudioManagerAndroid.DoLog("AudioEngineConfig getJsonConfig " + e.getMessage());
                return null;
            }
        }
    }

    private class MediaPhoneStateListener
    extends PhoneStateListener {
        private boolean mInCall = false;

        private MediaPhoneStateListener() {
        }

        public void onCallStateChanged(int state, String incomingNumber) {
            if (AudioManagerAndroid.this.mPhoneStateListenerRegistered) {
                AudioManagerAndroid.DoLog("MediaPhoneStateListener: " + state + ",incomingNumber " + incomingNumber);
                switch (state) {
                    case 0: {
                        if (!this.mInCall) break;
                        this.mInCall = false;
                        AudioManagerAndroid.this.nativeNotifyPhoneCallReceive(0);
                        AudioManagerAndroid.DoLog("MediaPhoneStateListener Not in Call");
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (this.mInCall) break;
                        this.mInCall = true;
                        AudioManagerAndroid.this.nativeNotifyPhoneCallReceive(1);
                        AudioManagerAndroid.DoLog("MediaPhoneStateListener in Call");
                    }
                }
            }
        }
    }
}

