/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import android.util.Log;
import com.yy.audioengine.AudioFileMixer;
import com.yy.audioengine.AudioFileMixerPoint;
import com.yy.audioengine.IFileMixerNotify;
import com.yy.audioengine.IKaraokeFileMixerNotity;

public class KaraokeFileMixer
implements IFileMixerNotify {
    private static String TAG = "KaraokeFileMixer";
    private AudioFileMixer mAudioFileMixer;
    private AudioFileMixerPoint mVoicePoint;
    private AudioFileMixerPoint mAccompanyPoint;
    private IKaraokeFileMixerNotity mNotify;

    public void Init() {
        Log.i((String)TAG, (String)"Init....");
        this.mAudioFileMixer = new AudioFileMixer();
    }

    public void Destroy() {
        Log.i((String)TAG, (String)"Destroy....");
        if (this.mVoicePoint != null) {
            this.mVoicePoint.Close();
            this.mVoicePoint = null;
        }
        if (this.mAccompanyPoint != null) {
            this.mAccompanyPoint.Close();
            this.mVoicePoint = null;
        }
        if (this.mAudioFileMixer != null) {
            this.mAudioFileMixer.Destroy();
            this.mAudioFileMixer = null;
        }
    }

    public void SetKaraokeFileMixerNotify(IKaraokeFileMixerNotity notify) {
        Log.i((String)TAG, (String)("SetKaraokeFileMixerNotify, notify: " + notify));
        this.mNotify = notify;
    }

    public boolean Open(String voiceFile, String accompanyFile) {
        Log.i((String)TAG, (String)("Open, voiceFile: " + voiceFile + " ,accompanyFile: " + accompanyFile));
        this.mAudioFileMixer.RegisterNotify(this);
        if (!this.OpenVoiceFile(voiceFile)) {
            return false;
        }
        if (!this.OpenAccompanyFile(accompanyFile)) {
            return false;
        }
        Log.i((String)TAG, (String)"Open, success....");
        return true;
    }

    private boolean OpenVoiceFile(String fileName) {
        AudioFileMixerPoint point = this.mAudioFileMixer.CreateMixerPoint();
        if (point.Open(fileName)) {
            this.mVoicePoint = point;
            return true;
        }
        point.Close();
        return false;
    }

    private boolean OpenAccompanyFile(String fileName) {
        AudioFileMixerPoint point = this.mAudioFileMixer.CreateMixerPoint();
        if (point.Open(fileName)) {
            this.mAccompanyPoint = point;
            return true;
        }
        point.Close();
        return false;
    }

    public boolean Start(String fileName) {
        Log.i((String)TAG, (String)("Start, fileName: " + fileName));
        boolean res = false;
        if (this.mAudioFileMixer != null) {
            res = this.mAudioFileMixer.Start(fileName);
        }
        return res;
    }

    public void Stop() {
        Log.i((String)TAG, (String)"Stop....");
        if (this.mAudioFileMixer != null) {
            this.mAudioFileMixer.Stop();
        }
    }

    public void SetVoiceVolume(int volume) {
    }

    public void SetAccompanyVolume(int volume) {
    }

    public void SetTone(int tone) {
    }

    private void EnableReverbEx(boolean enable) {
        if (this.mVoicePoint != null) {
            this.mVoicePoint.EnableReverbEx(enable);
        }
    }

    private void SetReverbParamEx(int[] array) {
        if (this.mVoicePoint != null) {
            this.mVoicePoint.SetReverbParameter(array);
        }
    }

    public void EnableReverbNew(boolean enable) {
        if (this.mVoicePoint != null) {
            this.mVoicePoint.EnableReverbFv3(enable);
        }
    }

    public void SetReverbNewParam(int[] array) {
        if (this.mVoicePoint != null) {
            this.mVoicePoint.SetReverbFv3Param(array);
        }
    }

    public void EnableEqualizer(boolean enable) {
        if (this.mVoicePoint != null) {
            this.mVoicePoint.EnableEqualizerEx(enable);
        }
    }

    public void SetEqGains(int[] array) {
        if (this.mVoicePoint != null) {
            this.mVoicePoint.SetEqualizerParameter(array);
        }
    }

    public void EnableCompressor(boolean enable) {
        if (this.mVoicePoint != null) {
            this.mVoicePoint.EnableCompressor(enable);
        }
    }

    public void SetCompressorParam(int[] array) {
        if (this.mVoicePoint != null) {
            this.mVoicePoint.SetCompressorParameter(array);
        }
    }

    @Override
    public void OnFileMixerState(long curTime, long totalTime) {
        Log.i((String)TAG, (String)("OnFileMixerState...curTime: " + curTime + " ,totalTime: " + totalTime));
        if (this.mNotify != null) {
            this.mNotify.OnFileMixerState(curTime, totalTime);
        }
    }

    @Override
    public void OnFinishMixer() {
        Log.i((String)TAG, (String)"OnFinishMixer...");
        if (this.mNotify != null) {
            this.mNotify.OnFinishMixer();
        }
    }
}

