/*
 * Decompiled with CFR 0.152.
 */
package com.yy.android.medialibrary.audiocodec;

import com.yy.android.medialibrary.audiocodec.Constant;

public class AudioEncoder {
    private static final String TAG = "AudioEncoder";
    private long mCodecCtx;

    public AudioEncoder(Constant.AudioCoderType codecType) {
        int codec = codecType.ordinal();
        this.mCodecCtx = this.nativeCreateAudioEncoder(codec);
    }

    public void Init() {
        this.nativeInit(this.mCodecCtx);
    }

    public void Uninit() {
        this.nativeUninit(this.mCodecCtx);
    }

    public void Flush() {
        this.nativeFlush(this.mCodecCtx);
    }

    public byte[] Encode(byte[] inPcm) {
        return this.nativeEncode(this.mCodecCtx, inPcm);
    }

    public byte[] EncodeLoss() {
        return this.nativeEncodeLoss(this.mCodecCtx);
    }

    public void SetBitRate(long bitRate) {
        this.nativeSetBitRate(this.mCodecCtx, bitRate);
    }

    public long GetEncoderBytes() {
        return this.nativeGetEncoderBytes(this.mCodecCtx);
    }

    public void SetComplexity(long complexity) {
        this.nativeSetComplexity(this.mCodecCtx, complexity);
    }

    private native long nativeCreateAudioEncoder(int var1);

    private native void nativeInit(long var1);

    private native void nativeUninit(long var1);

    private native void nativeFlush(long var1);

    private native void nativeSetBitRate(long var1, long var3);

    private native long nativeGetEncoderBytes(long var1);

    private native void nativeSetComplexity(long var1, long var3);

    private native byte[] nativeEncode(long var1, byte[] var3);

    private native byte[] nativeEncodeLoss(long var1);
}

