/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util;

import com.yy.hiidostatis.api.ExecutorProvider;
import com.yy.hiidostatis.inner.util.SharedThreadTimer;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.mobile.perf.taskexecutor.IQueueTaskExecutor;
import com.yy.mobile.perf.taskexecutor.IYYTaskExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ThreadPool {
    private static ThreadPool pool;
    private ExecutorService executorService;
    private ExecutorService singleExecutorService;
    private ScheduledExecutorService scheduledExecutorService;
    private IYYTaskExecutor taskExecutor;
    private IQueueTaskExecutor singleTaskExecutor;
    private ScheduledExecutorService spareExecutor;
    private SharedThreadTimer timer = new SharedThreadTimer();

    private ThreadPool() {
        if (ExecutorProvider.getIyyTaskExecutor() == null) {
            this.executorService = Executors.newFixedThreadPool(5);
            this.singleExecutorService = Executors.newSingleThreadExecutor();
            this.scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setPriority(1);
                    return thread;
                }
            });
        } else {
            this.taskExecutor = ExecutorProvider.getIyyTaskExecutor();
            this.singleTaskExecutor = this.taskExecutor.createAQueueExcuter();
            if (this.singleTaskExecutor == null) {
                this.singleExecutorService = Executors.newSingleThreadExecutor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPool getPool() {
        if (pool != null) return pool;
        Class<ThreadPool> clazz = ThreadPool.class;
        synchronized (ThreadPool.class) {
            if (pool != null) return pool;
            pool = new ThreadPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return pool;
        }
    }

    public SharedThreadTimer getTimer() {
        return this.timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledExecutorService getSpareExecutor() {
        if (this.spareExecutor != null) {
            return this.spareExecutor;
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.spareExecutor != null) {
                return this.spareExecutor;
            }
            this.spareExecutor = Executors.newScheduledThreadPool(1);
            return this.spareExecutor;
        }
    }

    public void execute(Runnable runnable) {
        if (this.taskExecutor != null) {
            try {
                this.taskExecutor.execute(runnable, 0L);
            }
            catch (Throwable e) {
                this.getSpareExecutor().execute(runnable);
            }
        } else {
            this.executorService.execute(runnable);
        }
    }

    public void executeQueue(Runnable runnable) {
        if (this.singleTaskExecutor != null) {
            try {
                this.singleTaskExecutor.execute(runnable, 0L);
            }
            catch (Throwable e) {
                this.getSpareExecutor().execute(runnable);
            }
        } else {
            this.singleExecutorService.execute(runnable);
        }
    }

    public <T> Future<T> submit(Callable<T> callable) {
        FutureTask<T> ftask = new FutureTask<T>(callable);
        this.execute(ftask);
        return ftask;
    }

    public <T> Future<T> submitQueue(Callable<T> callable) {
        FutureTask<T> ftask = new FutureTask<T>(callable);
        this.executeQueue(ftask);
        return ftask;
    }

    public void shutdownNow() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        if (this.singleExecutorService != null) {
            this.singleExecutorService.shutdownNow();
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
        if (this.spareExecutor != null) {
            this.spareExecutor.shutdownNow();
            this.spareExecutor = null;
        }
    }

    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.singleExecutorService != null) {
            this.singleExecutorService.shutdown();
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
        if (this.spareExecutor != null) {
            this.spareExecutor.shutdown();
            this.spareExecutor = null;
        }
    }

    public void execute(Runnable run, long delayMillis) {
        try {
            if (this.taskExecutor != null) {
                try {
                    this.taskExecutor.execute(run, delayMillis);
                }
                catch (Throwable e) {
                    this.getSpareExecutor().schedule(run, delayMillis, TimeUnit.MILLISECONDS);
                }
            } else {
                this.scheduledExecutorService.schedule(run, delayMillis, TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable e) {
            L.error(this, e.getMessage(), new Object[0]);
        }
    }
}

