/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.obj;

import com.yy.hiidostatis.defs.obj.Elem;
import com.yy.hiidostatis.defs.obj.ParamableElem;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class EventElementInfo
extends ParamableElem
implements Elem {
    private static final long serialVersionUID = 7740962417443813455L;
    public static final transient int CTYPE_CUSTOM_REPORT = 0;
    public static final transient int CTYPE_CLICK_TIMES_REPORT = 1;
    public static final transient int DEFAULT_CVALUE = 0;
    String cid;
    int ctype;
    String cvalue;
    private Property property = new Property();

    public EventElementInfo(String cid, int cvalue) {
        this.cid = cid;
        this.ctype = 1;
        this.cvalue = Integer.toString(cvalue);
    }

    public EventElementInfo(String cid, String cvalue) {
        this.cid = cid;
        this.ctype = 0;
        this.cvalue = cvalue;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.cid = (String)s.readObject();
        this.ctype = s.readInt();
        this.cvalue = s.readUTF();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.cid);
        s.writeInt(this.ctype);
        s.writeUTF(this.cvalue);
    }

    public String getEventId() {
        return this.cid;
    }

    void setCid(String cid) {
        this.cid = cid;
    }

    public int getEventType() {
        return this.ctype;
    }

    void setCtype(int ctype) {
        this.ctype = ctype;
    }

    public String getCustomValue() {
        return this.cvalue;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.property = property;
    }

    public void setCustomValue(String cvalue) {
        if (this.ctype == 1) {
            try {
                Long.parseLong(cvalue);
            }
            catch (NumberFormatException e) {
                L.error(this, "Input arg error %s for %s", cvalue, e);
            }
        }
        this.cvalue = cvalue;
    }

    @Override
    public String getStringRep() {
        String propertyString;
        StringBuilder sb = new StringBuilder();
        sb.append(Util.replaceEncode(this.cid, ":"));
        sb.append(":");
        sb.append(this.ctype);
        sb.append(":");
        sb.append(Util.replaceEncode(this.cvalue, ":"));
        sb.append(":");
        String paramString = this.getConnectedParams();
        if (!Util.empty(paramString)) {
            sb.append(Util.replaceEncode(paramString, ":"));
        }
        sb.append(":");
        String string = propertyString = this.property == null ? null : this.property.getConnectedPropertys();
        if (!Util.empty(propertyString)) {
            sb.append(Util.replaceEncode(propertyString, ":"));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("eventId=");
        sb.append(this.cid);
        sb.append(", event type=");
        sb.append(this.ctype == 0 ? "Custom" : "Times");
        sb.append(", value=");
        sb.append(this.cvalue);
        return sb.toString();
    }
}

