/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util.cipher;

import com.yy.hiidostatis.inner.util.cipher.Base64Util;
import com.yy.hiidostatis.inner.util.cipher.TextUtils;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesCipher {
    private static final int BLOCK_SIZE = 16;
    private static final String AES_CBC_NOPADDING = "AES/CBC/NoPadding";
    private static final ThreadLocal<Cipher> Cipher_AES_CBC_NOPADDING = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(AesCipher.AES_CBC_NOPADDING);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final byte[] m_key;

    public AesCipher(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        this.m_key = TextUtils.md5byte(key);
    }

    public String encryptTlogBytes(byte[] data) throws Exception {
        if (data == null || data.length == 0) {
            return null;
        }
        byte[] encryptData = this.encrypt(data);
        if (encryptData == null) {
            throw new Exception("EncryptData is null");
        }
        StringBuilder builder = new StringBuilder(data.length + encryptData.length * 2);
        builder.append(TextUtils.length2DecimalChar(data.length));
        builder.append(TextUtils.bytes2hex(encryptData));
        return builder.toString();
    }

    public byte[] decryptTlogHex(String hex) throws Exception {
        int validLength = TextUtils.getDecimalCharLength(hex);
        byte[] encryptData = TextUtils.hex2Bytes(hex, 8);
        if (encryptData == null || encryptData.length == 0) {
            return encryptData;
        }
        byte[] deBytes = this.decrypt(encryptData);
        if (validLength > deBytes.length) {
            throw new Exception(String.format("Expect data length [ %d ] ,but get [ %d ].", validLength, deBytes.length));
        }
        byte[] ans = new byte[validLength];
        System.arraycopy(deBytes, 0, ans, 0, validLength);
        return ans;
    }

    public String encryptTlogBytesBase64(byte[] data) throws Exception {
        if (data == null || data.length == 0) {
            return null;
        }
        byte[] encryptData = this.encrypt(data);
        if (encryptData == null) {
            throw new Exception("EncryptData is null");
        }
        StringBuilder builder = new StringBuilder(data.length + encryptData.length * 2);
        builder.append(TextUtils.length2DecimalChar(data.length));
        builder.append(Base64Util.encode(encryptData));
        return builder.toString();
    }

    public byte[] decryptTlogBase64(String base64) throws Exception {
        int validLength = TextUtils.getDecimalCharLength(base64);
        byte[] encryptData = Base64Util.decode(base64 = base64.substring(8));
        if (encryptData == null || encryptData.length == 0) {
            return encryptData;
        }
        byte[] deBytes = this.decrypt(encryptData);
        if (validLength > deBytes.length) {
            throw new Exception(String.format("Expect data length [ %d ] ,but get [ %d ].", validLength, deBytes.length));
        }
        byte[] ans = new byte[validLength];
        System.arraycopy(deBytes, 0, ans, 0, validLength);
        return ans;
    }

    public byte[] decrypt(byte[] encryptData) throws Exception {
        try {
            Cipher cipher = Cipher_AES_CBC_NOPADDING.get();
            cipher.init(2, (Key)new SecretKeySpec(this.m_key, "AES"), this.createIv());
            return cipher.doFinal(encryptData);
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    public byte[] decrypt(byte[] encryptData, int offset, int len) throws Exception {
        try {
            Cipher cipher = Cipher_AES_CBC_NOPADDING.get();
            cipher.init(2, (Key)new SecretKeySpec(this.m_key, "AES"), this.createIv());
            return cipher.doFinal(encryptData, offset, len);
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    public byte[] encrypt(byte[] content) throws Exception {
        try {
            Cipher cipher = Cipher_AES_CBC_NOPADDING.get();
            SecretKeySpec keyspec = new SecretKeySpec(this.m_key, "AES");
            cipher.init(1, (Key)keyspec, this.createIv());
            return cipher.doFinal(this.fillBlock(content));
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    private IvParameterSpec createIv() {
        byte[] ivb = new byte[this.m_key.length];
        System.arraycopy(this.m_key, 0, ivb, 0, this.m_key.length);
        return new IvParameterSpec(ivb);
    }

    private byte[] fillBlock(byte[] src) {
        int rest = src.length % 16;
        if (rest == 0) {
            return src;
        }
        int len = rest == 0 ? src.length : src.length + 16 - rest;
        byte[] r = new byte[len];
        System.arraycopy(src, 0, r, 0, src.length);
        return r;
    }
}

