/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util.http;

import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.cipher.AesCipher;
import com.yy.hiidostatis.inner.util.cipher.Base64Util;
import com.yy.hiidostatis.inner.util.cipher.RsaCipher;
import com.yy.hiidostatis.inner.util.http.AbstractStatisHttpUtil;
import com.yy.hiidostatis.inner.util.log.ActLog;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.ByteArrayInputStream;
import java.net.URI;

public class MetricsHttpEncryptUtil
extends AbstractStatisHttpUtil {
    private static final String RSA_PUB_KEY = "MCwwDQYJKoZIhvcNAQEBBQADGwAwGAIRAMRSvSVZEbyQwtFwNtNiZKkCAwEAAQ==";
    private static final String URL_PARAM = "act=mmetric&smkdata=$smkdata&EC=$EC&appkey=$appkey&item=$item";
    private static final String URL_FORMAT = "http://%s/c.gif";
    private static final String DEFAULT_URL_HOST = "mlog.hiido.com";
    private String mLastHost;
    private String mLastSmkData;
    private String urlParams;
    private String body;
    private static final String[] ADDRESSES = new String[]{"14.17.112.232", "14.17.112.233", "14.17.112.234", "14.17.112.235", "14.17.112.236", "14.17.112.237"};
    private String mUrlHost;
    private String mUrlService;
    private String[] mUrlAddress;
    private RsaCipher mRsaCipher = null;

    public MetricsHttpEncryptUtil(String urlHost, String[] urlAddress) {
        this.mUrlAddress = urlAddress == null ? ADDRESSES : urlAddress;
        this.mUrlHost = urlHost == null ? DEFAULT_URL_HOST : urlHost;
        this.mUrlService = String.format(URL_FORMAT, this.mUrlHost);
    }

    @Override
    protected String[] getUrlAddress() {
        return this.mUrlAddress;
    }

    @Override
    protected String getUrlFormat() {
        return URL_FORMAT;
    }

    @Override
    protected String getUrlService() {
        return this.mUrlService;
    }

    private RsaCipher getRsaCipher() throws Exception {
        if (this.mRsaCipher == null) {
            byte[] keyBytes = Base64Util.decode(RSA_PUB_KEY);
            ByteArrayInputStream bis = new ByteArrayInputStream(keyBytes);
            RsaCipher rc = new RsaCipher();
            rc.loadPublicKey(bis);
            this.mRsaCipher = rc;
        }
        return this.mRsaCipher;
    }

    @Override
    protected boolean sendContent(String url, String content, int tryTimes) {
        L.brief("hiido service address is %s", url);
        this.mThrowable = null;
        this.mLastHost = null;
        this.mLastSmkData = null;
        int initialTimes = tryTimes;
        String encryptUrl = String.format("%s?%s", url, URL_PARAM);
        String encryptContent = content;
        try {
            String aesKey = "";
            String data = encryptContent;
            aesKey = Util.getRandStringEx(4);
            AesCipher aesCipher = new AesCipher(aesKey.getBytes());
            data = aesCipher.encryptTlogBytesBase64(data.getBytes("UTF-8"));
            aesCipher = null;
            encryptUrl = String.format("%s&enc=b64", encryptUrl);
            aesKey = this.getRsaCipher().encryptTlogAesKey(aesKey.getBytes());
            encryptContent = data;
            encryptUrl = encryptUrl.replace("$smkdata", aesKey);
            encryptUrl = encryptUrl.replace("$appkey", Util.parseParam(content, "appkey"));
            encryptUrl = encryptUrl.replace("$item", Util.parseParam(content, "act"));
            this.mLastSmkData = aesKey;
            this.mLastHost = new URI(url).getHost();
        }
        catch (Throwable e) {
            L.error(this, "encrypt exception = %s", e);
            this.mThrowable = e;
            String error = this.statusCode + "|encrypt exception=" + e;
            ActLog.writeSendFailLog(null, this.mLastSmkData, this.mLastHost, content, error, String.valueOf(this.getLastStatusCode()), null);
            return false;
        }
        String tmpEncryptUrl = encryptUrl;
        do {
            String error;
            try {
                if (this.getLastTryTimes() > 0) {
                    ActLog.writeActLog(null, "Retry", content, null, null, null);
                }
                encryptUrl = tmpEncryptUrl.replace("$EC", this.lastTryTimes + "");
                if (initialTimes != tryTimes) {
                    L.brief("Try again to send %s with url %s, tried times %d.", encryptContent, encryptUrl, initialTimes - tryTimes);
                }
                ++this.lastTryTimes;
                int pindex = encryptUrl.indexOf("?");
                this.urlParams = encryptUrl.substring(pindex + 1);
                this.body = encryptContent;
                if (this.post(encryptUrl, encryptContent)) {
                    this.mThrowable = null;
                    ActLog.writeSendSucLog(null, this.mLastSmkData, this.mLastHost, content);
                    ActLog.writeActLog(null, "Suc", content, this.mLastSmkData, this.mLastHost, null);
                    L.debug(this, "Successfully sent %s to %s", encryptContent, encryptUrl);
                    return true;
                }
                L.debug(this, "Failed to send %s to %s.", encryptContent, encryptUrl);
                error = this.statusCode + "|" + this.reasonPhrase + "|";
                ActLog.writeSendFailLog(null, this.mLastSmkData, this.mLastHost, content, error, String.valueOf(this.getLastStatusCode()), this.getLastTryTimes());
                ActLog.writeActLog(null, "Fail", content, null, null, null);
            }
            catch (Throwable e) {
                this.mThrowable = e;
                L.error(MetricsHttpEncryptUtil.class, "guid:%s. http statis exception %s", Util.parseParam(content, "guid"), e);
                try {
                    error = this.statusCode + "|" + e + "|" + e.getCause();
                    ActLog.writeSendFailLog(null, this.mLastSmkData, this.mLastHost, content, error, this.getLastStatusCode() + "", this.getLastTryTimes());
                    ActLog.writeActLog(null, "Fail", content, null, null, null);
                }
                catch (Throwable e1) {
                    L.error(this, e1.getMessage(), new Object[0]);
                }
            }
        } while (tryTimes-- > 0);
        return false;
    }

    @Override
    public String getUrlParams() {
        return this.urlParams;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    public String getLastHost() {
        return this.mLastHost;
    }

    public String getLastSmkData() {
        return this.mLastSmkData;
    }

    @Override
    public String getHost() {
        String host = this.mLastHost != null && !this.mLastHost.isEmpty() ? this.mLastHost : this.mUrlHost;
        return host == null ? "" : host;
    }
}

