/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.obj;

import com.yy.hiidostatis.defs.obj.ActionResult;
import com.yy.hiidostatis.defs.obj.Counter;
import com.yy.hiidostatis.defs.obj.IJsonSerialize;
import com.yy.hiidostatis.defs.obj.MetricsValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MetricsPkg {
    private ConcurrentLinkedQueue<IJsonSerialize> reqData = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<IJsonSerialize> metricsValues = new ConcurrentLinkedQueue();
    private HashMap<String, Counter> counterData = new HashMap();
    private int maxCount;

    public MetricsPkg(int maxCount) {
        this.maxCount = maxCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCounter(Counter counter) {
        String key = counter.getKey();
        Counter c = this.counterData.get(key);
        boolean ret = false;
        if (c == null) {
            HashMap<String, Counter> hashMap = this.counterData;
            synchronized (hashMap) {
                Counter one = this.counterData.get(key);
                if (one == null) {
                    this.counterData.put(key, (Counter)counter.clone());
                    ret = true;
                } else {
                    one.count(counter.getValue(), counter.getInvokeCount());
                }
            }
        } else {
            c.count(counter.getValue(), counter.getInvokeCount());
        }
        return ret;
    }

    public void addActionResult(ActionResult req) {
        this.reqData.add(req);
    }

    public void addMetricsValue(MetricsValue req) {
        this.metricsValues.add(req);
    }

    public boolean isEmpty() {
        return this.reqData.isEmpty() && this.metricsValues.isEmpty() && this.counterData.isEmpty();
    }

    public List<JSONObject> toJson() {
        JSONObject obj;
        ArrayList<JSONObject> arr = new ArrayList<JSONObject>();
        long time = System.currentTimeMillis();
        int count = 0;
        Iterator<IJsonSerialize> iterator1 = this.reqData.iterator();
        JSONArray reqs = new JSONArray();
        while (iterator1.hasNext()) {
            reqs.put((Object)iterator1.next().toJson());
            if (++count < this.maxCount) continue;
            JSONObject obj2 = this.cutPiece(reqs, null, null, time);
            if (obj2 != null) {
                arr.add(obj2);
            }
            reqs = new JSONArray();
            count = 0;
        }
        Iterator<Counter> iterator2 = this.counterData.values().iterator();
        JSONArray cs = new JSONArray();
        while (iterator2.hasNext()) {
            cs.put((Object)iterator2.next().toJson());
            if (++count < this.maxCount) continue;
            JSONObject obj3 = this.cutPiece(reqs, cs, null, time);
            if (obj3 != null) {
                arr.add(obj3);
            }
            reqs = new JSONArray();
            cs = new JSONArray();
            count = 0;
        }
        Iterator<IJsonSerialize> iterator3 = this.metricsValues.iterator();
        JSONArray mvs = new JSONArray();
        while (iterator3.hasNext()) {
            mvs.put((Object)iterator3.next().toJson());
            if (++count < this.maxCount) continue;
            obj = this.cutPiece(reqs, cs, mvs, time);
            if (obj != null) {
                arr.add(obj);
            }
            reqs = new JSONArray();
            cs = new JSONArray();
            mvs = new JSONArray();
            count = 0;
        }
        if (reqs.length() + cs.length() + mvs.length() > 0 && (obj = this.cutPiece(reqs, cs, mvs, time)) != null) {
            arr.add(obj);
        }
        return arr;
    }

    private JSONObject cutPiece(JSONArray reqs, JSONArray counts, JSONArray mvs, long time) {
        JSONObject ret = new JSONObject();
        try {
            if (reqs != null) {
                ret.put("reqdata", (Object)reqs);
            }
            if (counts != null) {
                ret.put("counterdata", (Object)counts);
            }
            if (mvs != null) {
                ret.put("flatdata", (Object)mvs);
            }
            ret.put("clienttime", time);
            return ret;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

