/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import com.yy.hiidostatis.inner.util.Counter;
import com.yy.hiidostatis.inner.util.log.L;

public class FlushManager {
    private FlushListener l;
    private ConnectionChangeReceiver mReceiver;
    private static final Object OBJ_KEY = new Object();
    private ReportTimer mReportTimer = new ReportTimer();
    private static Handler mHandler = new Handler(Looper.getMainLooper());

    public void setFlushListener(FlushListener l) {
        this.l = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regConnectionChangeReceiver(Context c) {
        c = c.getApplicationContext();
        if (this.mReceiver == null) {
            Object object = OBJ_KEY;
            synchronized (object) {
                if (this.mReceiver == null) {
                    this.mReceiver = new ConnectionChangeReceiver();
                    this.mReceiver.registerReceiver(c);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegConnectionChangeReceiver(Context c) {
        c = c.getApplicationContext();
        if (this.mReceiver != null) {
            Object object = OBJ_KEY;
            synchronized (object) {
                if (this.mReceiver != null) {
                    this.mReceiver.unregisterReceiver(c);
                    this.mReceiver = null;
                }
            }
        }
    }

    public void startTimer(Context c, Long interval) {
        this.mReportTimer.start(mHandler, c, interval);
    }

    public void stopTimer(Context context) {
        this.mReportTimer.stop(context);
    }

    private class ReportTimer {
        private Counter mReportInvoker;
        private Counter.Callback mReportExecutor;
        private static final long DEFAULT_INTERVAL = 1800000L;
        private static final long MAX_INTERVAL = 3600000L;
        private static final long MIN_INTERVAL = 60000L;
        private long mInterval = 1800000L;

        private ReportTimer() {
        }

        public void start(Handler handler, final Context c, Long interval) {
            try {
                if (this.mReportInvoker != null) {
                    return;
                }
                if (interval != null && interval >= 60000L && interval <= 3600000L) {
                    this.mInterval = interval;
                }
                this.mReportInvoker = new Counter(handler, 0, this.mInterval, true);
                this.mReportExecutor = new Counter.Callback(){

                    @Override
                    public void onCount(int counter) {
                        if (FlushManager.this.l != null) {
                            L.debug(this, "ReportTimer. flush cache. %d times", counter + 1);
                            FlushManager.this.l.fluch(c);
                        }
                    }
                };
                this.mReportInvoker.setCallback(this.mReportExecutor);
                this.mReportInvoker.start(this.mInterval);
                L.brief("ReportTimer start. interval:%d ms", this.mInterval);
            }
            catch (Throwable e) {
                L.error(this, e.getMessage(), new Object[0]);
            }
        }

        public void stop(Context context) {
            if (this.mReportInvoker == null) {
                return;
            }
            try {
                L.brief("ReportTimer stop.", new Object[0]);
                this.mReportInvoker.stop();
                this.mReportInvoker = null;
                this.mReportExecutor = null;
            }
            catch (Throwable e) {
                L.error(this, e.getMessage(), new Object[0]);
            }
        }
    }

    private class ConnectionChangeReceiver
    extends BroadcastReceiver {
        private ConnectionChangeReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.net.conn.CONNECTIVITY_CHANGE") && FlushManager.this.l != null) {
                L.verbose((Object)this, "ConnectionChangeReceiver onReceive .flush cache", new Object[0]);
                FlushManager.this.l.fluch(context);
            }
        }

        public void registerReceiver(Context c) {
            try {
                L.debug((Object)this, "ConnectionChangeReceiver registerReceiver", new Object[0]);
                IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
                c.registerReceiver((BroadcastReceiver)this, filter);
            }
            catch (Throwable e) {
                L.warn((Object)this, "ConnectionChangeReceiver registerReceiver failure", new Object[0]);
            }
        }

        public void unregisterReceiver(Context c) {
            try {
                L.debug((Object)this, "ConnectionChangeReceiver unregisterReceiver", new Object[0]);
                c.unregisterReceiver((BroadcastReceiver)this);
            }
            catch (Throwable e) {
                L.warn((Object)this, "ConnectionChangeReceiver unregisterReceiver failure", new Object[0]);
            }
        }
    }

    public static interface FlushListener {
        public void fluch(Context var1);
    }
}

