/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiido.autoviewtrack;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.yy.hiidostatis.defs.controller.HttpSendController;
import com.yy.hiidostatis.defs.obj.Act;
import com.yy.hiidostatis.defs.obj.IJsonSerialize;
import com.yy.hiidostatis.inner.implementation.CommonFiller;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.cipher.Base64Util;
import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public class AutoTrackWorker {
    public int maxCount;
    private HttpSendController httpSendController;
    private List<IJsonSerialize> tracks;
    private AtomicInteger count = new AtomicInteger(0);
    private long expire;
    private String appKey;
    private String appVer;
    private Context context;
    private String sdkVer;
    private String osVer;

    public AutoTrackWorker(Context context, int maxCount, HttpSendController httpSendController, long expire, String appKey, String appVer, String sdkVer) {
        this.maxCount = maxCount;
        this.httpSendController = httpSendController;
        this.expire = expire;
        this.appKey = appKey;
        this.appVer = appVer;
        this.context = context;
        this.sdkVer = sdkVer;
        this.tracks = new ArrayList<IJsonSerialize>(maxCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrackEvent(IJsonSerialize event) {
        List<IJsonSerialize> tmp = null;
        List<IJsonSerialize> list = this.tracks;
        synchronized (list) {
            this.tracks.add(event);
            if (this.tracks.size() >= this.maxCount) {
                tmp = this.tracks;
                this.tracks = new ArrayList<IJsonSerialize>(this.maxCount);
            }
        }
        if (tmp != null) {
            this.pack(tmp);
        }
    }

    public void pack(final List<IJsonSerialize> data) {
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                JSONArray arr = new JSONArray();
                for (IJsonSerialize one : data) {
                    JSONObject obj = one.toJson();
                    if (obj == null) continue;
                    arr.put((Object)obj);
                }
                if (arr.length() == 0) {
                    return;
                }
                String content = AutoTrackWorker.this.toContent(arr);
                Log.i((String)"content", (String)content);
                byte[] b = AutoTrackWorker.this.gzip(content);
                String b64 = Base64Util.encode(b);
                String con = null;
                try {
                    String encoded = URLEncoder.encode(b64, "utf-8");
                    String timeStamp = String.valueOf(Util.wallTimeSec());
                    String key = URLEncoder.encode(CommonFiller.calKey(Act.MBSDK_GZIP_BATCH.toString(), timeStamp), "utf-8");
                    con = String.format("appkey=%s&act=%s&time=%s&key=%s&gzip=%s", AutoTrackWorker.this.appKey, Act.MBSDK_GZIP_BATCH.toString(), timeStamp, key, encoded);
                    AutoTrackWorker.this.httpSendController.send(con, AutoTrackWorker.this.expire);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] gzip(String src) {
        ByteArrayOutputStream out = null;
        DeflaterOutputStream gzip = null;
        try {
            byte[] ret;
            byte[] b = src.getBytes("utf-8");
            out = new ByteArrayOutputStream(b.length);
            gzip = new GZIPOutputStream(out);
            ((GZIPOutputStream)gzip).write(b, 0, b.length);
            gzip.close();
            gzip = null;
            byte[] byArray = ret = out.toByteArray();
            return byArray;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private String toContent(JSONArray data) {
        try {
            JSONObject content = new JSONObject();
            String timeStamp = String.valueOf(Util.wallTimeSec());
            content.put("act", (Object)Act.MBSDK_USER_ACTION.toString());
            content.put("time", (Object)timeStamp);
            content.put("key", (Object)CommonFiller.calKey(Act.MBSDK_USER_ACTION.toString(), timeStamp));
            content.put("appkey", (Object)this.appKey);
            content.put("ver", (Object)this.notNull(this.appVer));
            content.put("sdkver", (Object)this.notNull(this.sdkVer));
            content.put("sys", 2);
            content.put("osver", (Object)this.notNull(this.osVer == null ? (this.osVer = ArdUtil.getOS()) : this.osVer));
            content.put("model", (Object)this.notNull(Build.MODEL));
            content.put("net", ArdUtil.getNetworkTypeNew(this.context));
            content.put("ntm", (Object)ArdUtil.getNtm(this.context));
            content.put("hdid", (Object)DeviceProxy.getHdid(this.context));
            content.put("imei", (Object)CommonFiller.getIMEI(this.context));
            content.put("mac", (Object)CommonFiller.getMacAddr(this.context));
            content.put("sjp", (Object)ArdUtil.getSjp(this.context));
            content.put("items", (Object)data);
            return content.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private String notNull(String str) {
        return str == null ? "" : str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimer() {
        List<IJsonSerialize> tmp = null;
        List<IJsonSerialize> list = this.tracks;
        synchronized (list) {
            if (this.tracks.size() > 0) {
                tmp = this.tracks;
                this.tracks = new ArrayList<IJsonSerialize>(this.maxCount);
            }
        }
        if (tmp != null) {
            this.pack(tmp);
        }
    }
}

