/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.controller;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import com.yy.hiidostatis.defs.interf.IConfigAPI;
import com.yy.hiidostatis.defs.interf.IStatisAPI;
import com.yy.hiidostatis.defs.obj.RecentAppInfo;
import com.yy.hiidostatis.inner.util.DefaultPreference;
import com.yy.hiidostatis.inner.util.FindEmulator;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.cipher.AesCipher;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppAnalyzeController {
    private static final String AES_KEY = "*&Hjkfa{{07";
    private static final int MAX_APPLIST_COUNT = 100;
    private static final String USER_APP = "2";
    private static final String SYSTEM_APP = "1";
    private static final String PREF_KEY_APP_ANALYZE_REPORT_DATE = "PREF_KEY_APP_ANALYZE_REPORT_DATE";
    private static final int SPLIT_SIZE = 50;
    private IStatisAPI statisAPI;
    private IConfigAPI mConfigAPI;

    public AppAnalyzeController(IStatisAPI statisAPI, IConfigAPI configAPI) {
        this.statisAPI = statisAPI;
        this.mConfigAPI = configAPI;
    }

    public void reportAppAnalyze(Context context, long uid) {
        this.startAppAnalyzeReport(context, uid);
    }

    public void reportRecentAppAnalyze(final Context context, final long uid) {
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AppAnalyzeController.this.reportRecentUsedApp(context, uid);
                }
                catch (Throwable e) {
                    L.errorOn(AppAnalyzeController.class, "reportRecentUsedApp exception:%s", e.getMessage());
                }
            }
        }, 18000L);
    }

    private String getCurrDate() {
        return Util.formatDate("yyyyMMdd", System.currentTimeMillis());
    }

    private void startAppAnalyzeReport(final Context context, final long uid) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                boolean isReported = false;
                String currDate = AppAnalyzeController.this.getCurrDate();
                String reportDate = DefaultPreference.getPreference().getPrefString(context, AppAnalyzeController.PREF_KEY_APP_ANALYZE_REPORT_DATE, "");
                isReported = reportDate.equals(currDate);
                if (isReported) {
                    L.debug(AppAnalyzeController.class, "AppAnalyze is reported today[%s]\uff0cso not report again!", currDate);
                    return;
                }
                JSONObject json = AppAnalyzeController.this.mConfigAPI.getAppListConfig(context, true);
                boolean enable = true;
                boolean sysAppEnable = false;
                try {
                    if (json != null && json.has("enable") && "0".equals(json.get("enable") + "")) {
                        enable = false;
                    }
                    if (json != null && json.has("sysAppEnable") && AppAnalyzeController.SYSTEM_APP.equals(json.get("sysAppEnable") + "")) {
                        sysAppEnable = true;
                    }
                    if (!sysAppEnable && FindEmulator.isEmulator(context) && json != null && json.has("emuSysAppEnable") && AppAnalyzeController.SYSTEM_APP.equals(json.get("emuSysAppEnable") + "")) {
                        L.brief("emuSysAppEnable is true && isEmulator is true", new Object[0]);
                        sysAppEnable = true;
                    }
                }
                catch (JSONException e) {
                    L.error(AppAnalyzeController.class, "get json.enable exception: %s", new Object[]{e});
                }
                L.debug(AppAnalyzeController.class, "AppAnalyze enable is %b\uff0csysAppEnable is %b", enable, sysAppEnable);
                if (enable) {
                    Map<String, List<Map<String, Object>>> list = AppAnalyzeController.this.getAllApps(context, sysAppEnable, 100, json);
                    AppAnalyzeController.this.reportAppListBySplit(list.get(AppAnalyzeController.USER_APP), uid, AppAnalyzeController.USER_APP);
                    List<Map<String, Object>> sysApp = list.get(AppAnalyzeController.SYSTEM_APP);
                    if (sysApp != null && !sysApp.isEmpty()) {
                        AppAnalyzeController.this.reportAppListBySplit(sysApp, uid, AppAnalyzeController.SYSTEM_APP);
                    }
                }
                DefaultPreference.getPreference().setPrefString(context, AppAnalyzeController.PREF_KEY_APP_ANALYZE_REPORT_DATE, currDate);
            }
        };
        ThreadPool.getPool().execute(r);
    }

    private List<Map<String, Object>> getSpecial(List<Map<String, Object>> list, String type, JSONObject json) {
        ArrayList<Map<String, Object>> speList = null;
        try {
            if (json == null || !json.has("appListConfig")) {
                return speList;
            }
            JSONArray appList = json.getJSONArray("appListConfig");
            if (appList == null || appList.length() == 0) {
                return speList;
            }
            speList = new ArrayList<Map<String, Object>>();
            JSONObject appJson = null;
            String pkgName = null;
            String tmpPkgName = null;
            String isExact = null;
            for (Map<String, Object> map : list) {
                if (!type.equals(map.get("type"))) continue;
                pkgName = map.get("appid") + "";
                for (int i = 0; i < appList.length(); ++i) {
                    appJson = appList.getJSONObject(i);
                    tmpPkgName = appJson.getString("scheme");
                    String string = isExact = appJson.has("isExact") ? appJson.get("isExact") + "" : SYSTEM_APP;
                    if ("0".equals(isExact)) {
                        if (!pkgName.contains(tmpPkgName)) continue;
                        speList.add(map);
                        L.brief("getSpecial isExact(0).pkgName:%s,tmpPkgName:%s", pkgName, tmpPkgName);
                        continue;
                    }
                    if (!pkgName.equals(tmpPkgName)) continue;
                    speList.add(map);
                    L.brief("getSpecial isExact(1).pkgName:%s,tmpPkgName:%s", pkgName, tmpPkgName);
                }
            }
        }
        catch (Throwable e) {
            L.warn(this, "getSpecial exception = %s", e);
        }
        return speList;
    }

    private void reportAppListBySplit(List<Map<String, Object>> list, long uid, String type) {
        if (list == null) {
            return;
        }
        ArrayList<Map<String, Object>> tmpList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : list) {
            tmpList.add(map);
            if (tmpList.size() != 50) continue;
            this.reportAppList(tmpList, uid, type);
            tmpList.clear();
        }
        if (tmpList.size() > 0) {
            this.reportAppList(tmpList, uid, type);
        }
    }

    private void reportAppList(List<Map<String, Object>> list, long uid, String type) {
        String applist = this.getAppList(list, type);
        String applist2 = this.getAppList2(list, type);
        this.statisAPI.reportAppList(uid, type, applist, applist2);
    }

    private String getAppList(List<Map<String, Object>> list, String type) {
        StringBuffer sb = new StringBuffer();
        if (list != null) {
            for (Map<String, Object> map : list) {
                if (!type.equals(map.get("type"))) continue;
                sb.append(map.get("appname")).append("|");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            L.debug(AppAnalyzeController.class, "type=%s,applist length=%d,applist bypes length=%d", type, sb.toString().length(), sb.toString().getBytes().length);
            L.debug(AppAnalyzeController.class, "applist=%s", sb.toString());
        }
        return sb.toString();
    }

    private String getAppList2(List<Map<String, Object>> list, String type) {
        StringBuffer sb = new StringBuffer();
        if (list != null) {
            for (Map<String, Object> map : list) {
                if (!type.equals(map.get("type"))) continue;
                sb.append(map.get("appname")).append(";").append(map.get("appid")).append(";").append(map.get("firstInstallTime")).append(";").append(map.get("lastUpdateTime")).append("|");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            L.debug(AppAnalyzeController.class, "type=%s,applist2 length=%d,applist2 bypes length=%d", type, sb.toString().length(), sb.toString().getBytes().length);
            L.debug(AppAnalyzeController.class, "applist2=%s", sb.toString());
        }
        return sb.toString();
    }

    private boolean isSpecial(JSONArray appList, String pkgName) {
        if (appList == null || pkgName == null) {
            return false;
        }
        try {
            boolean ret = false;
            for (int i = 0; i < appList.length(); ++i) {
                String isExact;
                JSONObject appJson = appList.getJSONObject(i);
                String tmpPkgName = appJson.getString("scheme");
                String string = isExact = appJson.has("isExact") ? appJson.get("isExact") + "" : SYSTEM_APP;
                if ("0".equals(isExact)) {
                    if (!pkgName.contains(tmpPkgName)) continue;
                    ret = true;
                    break;
                }
                if (!pkgName.equals(tmpPkgName)) continue;
                ret = true;
                break;
            }
            return ret;
        }
        catch (Throwable e) {
            L.brief("error:%s", e.getMessage());
            return false;
        }
    }

    @SuppressLint(value={"NewApi"})
    public Map<String, List<Map<String, Object>>> getAllApps(Context context, boolean sysAppEnable, int maxApplistCount, JSONObject json) {
        ArrayList userApp = new ArrayList();
        ArrayList sysApp = new ArrayList();
        JSONArray cfgAppList = null;
        try {
            JSONArray appList;
            if (json != null && json.has("appListConfig") && (appList = json.getJSONArray("appListConfig")) != null && appList.length() > 0) {
                cfgAppList = appList;
            }
            PackageManager pManager = context.getPackageManager();
            List paklist = pManager.getInstalledPackages(0);
            ArrayList list = null;
            int count = 0;
            for (int i = 0; i < paklist.size(); ++i) {
                String type;
                PackageInfo pak = (PackageInfo)paklist.get(i);
                if ((pak.applicationInfo.flags & 1) > 0) {
                    if (!sysAppEnable && !this.isSpecial(cfgAppList, pak.applicationInfo.packageName)) continue;
                    type = SYSTEM_APP;
                    list = sysApp;
                } else {
                    type = USER_APP;
                    list = userApp;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("type", type);
                map.put("appname", pManager.getApplicationLabel(pak.applicationInfo).toString());
                map.put("appid", pak.applicationInfo.packageName);
                if (Build.VERSION.SDK_INT >= 9) {
                    map.put("firstInstallTime", pak.firstInstallTime / 1000L);
                    map.put("lastUpdateTime_", pak.lastUpdateTime / 1000L);
                } else {
                    map.put("firstInstallTime", 0);
                    map.put("lastUpdateTime_", 0);
                }
                try {
                    String dir = pak.applicationInfo.publicSourceDir;
                    map.put("dir", dir);
                    long lastModiriedTime = new File(dir).lastModified();
                    map.put("lastUpdateTime", lastModiriedTime / 1000L);
                }
                catch (Throwable e) {
                    map.put("lastUpdateTime", 0);
                    L.warn(AppAnalyzeController.class, "exception on get updatetime info: %s", e);
                }
                list.add(map);
                if (++count > 100) break;
            }
            HashMap<String, List<Map<String, Object>>> ret = new HashMap<String, List<Map<String, Object>>>(2);
            if (!sysApp.isEmpty()) {
                ret.put(SYSTEM_APP, sysApp);
            }
            if (!userApp.isEmpty()) {
                ret.put(USER_APP, userApp);
            }
            return ret;
        }
        catch (Throwable e) {
            L.warn(AppAnalyzeController.class, "exception on get All Apps info: %s", e);
            return null;
        }
    }

    private void reportRecentUsedApp(Context context, long uid) {
    }

    private String appInfoToString(List<RecentAppInfo> apps) {
        StringBuffer sb = new StringBuffer();
        String uap = null;
        if (apps != null) {
            for (RecentAppInfo app : apps) {
                sb.append(app.getName()).append(";").append(app.getPkg()).append(";").append(app.getLastModified()).append("|");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            uap = sb.toString();
        }
        return uap;
    }

    private void sendRecentApp(List<RecentAppInfo> userApp, List<RecentAppInfo> systemApp, long uid) {
        this.statisAPI.reportRecentAppList(uid, this.appInfoToString(userApp), this.appInfoToString(systemApp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRecentApp(Context context, List<RecentAppInfo> recent) {
        String tmpFile = context.getExternalCacheDir().getAbsolutePath() + "/ruar.tmp";
        File dir = Environment.getExternalStorageDirectory();
        File androidDir = new File(dir.getAbsolutePath() + "/Android");
        if (!androidDir.exists() || !androidDir.isDirectory()) {
            androidDir.mkdirs();
        }
        File rf = new File(androidDir.getAbsolutePath() + "/ruar.sec");
        JSONObject json = new JSONObject();
        FileOutputStream out = null;
        try {
            json.put("version", 1);
            JSONArray arr = new JSONArray();
            for (RecentAppInfo appInfo : recent) {
                JSONObject one = appInfo.toJson();
                if (one == null) continue;
                arr.put((Object)one);
            }
            json.put("fs", (Object)arr);
            String str = json.toString();
            AesCipher ac = new AesCipher(AES_KEY.getBytes());
            byte[] encry = ac.encrypt(str.getBytes("UTF-8"));
            out = new FileOutputStream(tmpFile);
            out.write(encry);
            out.flush();
            out.close();
            out = null;
            rf.delete();
            new File(tmpFile).renameTo(rf);
        }
        catch (Throwable e) {
            L.error(this, e.getMessage(), new Object[0]);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, RecentAppInfo> loadRecord() {
        File dir = Environment.getExternalStorageDirectory();
        File rf = new File(dir.getAbsolutePath() + "/Android/ruar.sec");
        HashMap<String, RecentAppInfo> ret = new HashMap<String, RecentAppInfo>();
        if (rf.exists()) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(rf);
                byte[] data = Util.readInputStream(inputStream);
                AesCipher ac = new AesCipher(AES_KEY.getBytes());
                byte[] dec = ac.decrypt(data);
                String content = new String(dec, "utf-8").trim();
                JSONObject obj = new JSONObject(content);
                int v = obj.getInt("version");
                JSONArray fs = obj.getJSONArray("fs");
                if (fs != null) {
                    for (int i = 0; i < fs.length(); ++i) {
                        JSONObject one = fs.getJSONObject(i);
                        RecentAppInfo ra = RecentAppInfo.fromJson(one);
                        if (ra == null) continue;
                        ret.put(ra.getPkg(), ra);
                    }
                }
                HashMap<String, RecentAppInfo> hashMap = ret;
                return hashMap;
            }
            catch (Throwable e) {
                L.error(this, e.getMessage(), new Object[0]);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return ret;
    }

    private List<RecentAppInfo> scanSdFileForLastModifiedTime(Context context) {
        File dir = Environment.getExternalStorageDirectory();
        File android = new File(dir.getAbsolutePath() + "/Android/data");
        if (android.exists() && android.isDirectory()) {
            File[] files = android.listFiles();
            ArrayList<RecentAppInfo> ret = new ArrayList<RecentAppInfo>(files.length);
            for (File f : files) {
                long time = this.lastModify(f, 0L);
                if (time == 0L) {
                    time = f.lastModified();
                }
                RecentAppInfo ra = new RecentAppInfo();
                ra.setPkg(f.getName());
                ra.setLastModified(time);
                ret.add(ra);
            }
            return ret;
        }
        return null;
    }

    private long lastModify(File file, long cur) {
        if (file.isDirectory()) {
            File[] fs;
            for (File f : fs = file.listFiles()) {
                long tmp = this.lastModify(f, cur);
                if (tmp <= cur) continue;
                cur = tmp;
            }
            return cur;
        }
        if (file.lastModified() > cur) {
            return file.lastModified();
        }
        return cur;
    }
}

