/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner;

import android.content.Context;
import com.yy.hiidostatis.inner.AbstractConfig;
import com.yy.hiidostatis.inner.util.DefaultPreference;
import com.yy.hiidostatis.inner.util.Preference;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.cipher.Coder;
import com.yy.hiidostatis.inner.util.http.HttpUtil;
import com.yy.hiidostatis.inner.util.log.L;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.json.JSONException;
import org.json.JSONObject;

public class GeneralConfigTool {
    private static Preference preference = new Preference("hdcommon_config_cache_pref", true);
    private String URL_CONFIG_SERVER;
    private static final String KEY_MAGIC = "HiidoData";
    private static final String KEY_CODE = "code";
    private static final String KEY_DATA = "data";
    private static final String KEY_MSG = "msg";
    private static final String KEY_TIME = "time";
    private static final String KEY_LAST_MODIFIED_TIME = "lastModifiedTime";
    private static final String KEY_CODE_STATUS_SUCCESS = "1";
    private static final String KEY_CODE_STATUS_NOT_MODIFIED = "2";
    private static final String PRFKEY_SRV_TM = "PRFKEY_SRV_TM";
    private static final long MAX_CACHE_TIME = 86400000L;
    private AbstractConfig mConfig;
    private Context mContext;

    public GeneralConfigTool(Context context, AbstractConfig config) {
        this.mContext = context;
        this.mConfig = config;
        this.URL_CONFIG_SERVER = config.getUrlConfigServer();
    }

    public AbstractConfig getConfig() {
        return this.mConfig;
    }

    public void setmConfig(AbstractConfig mConfig) {
        this.mConfig = mConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCache(String r, Map<String, String> params, Context context, boolean isDecrypt) throws Exception {
        String result = "";
        String cacheResult = "";
        long currTime = System.currentTimeMillis();
        String cacheKey = this.assblyCacheKey(r, params);
        String prefKeyTime = "prefKeyTime_" + cacheKey;
        String prefKeyData = "prefKeyData_" + cacheKey;
        String string = cacheKey;
        synchronized (string) {
            long cacheTime = preference.getPrefLong(context, prefKeyTime, 0L);
            cacheResult = preference.getPrefString(context, prefKeyData, "");
            L.brief("prefKeyTime:%s", cacheTime);
            L.brief("prefKeyData:%s", cacheResult);
            if (currTime - cacheTime <= 86400000L) {
                result = cacheResult;
                L.verbose(GeneralConfigTool.class, "get cache success,result is %s", result);
            }
            if (Util.empty(result)) {
                result = this.get(r, params, context, isDecrypt);
                if (result != null) {
                    L.debug(GeneralConfigTool.class, "get remote success,result is %s", result);
                    preference.setPrefLong(context, prefKeyTime, currTime);
                    preference.setPrefString(context, prefKeyData, result);
                } else {
                    L.verbose(GeneralConfigTool.class, "get cache because get remote is null", result);
                    result = cacheResult;
                }
            }
        }
        return result;
    }

    public String get(String r, Map<String, String> params, Context context, boolean isDecrypt) {
        String url = this.assblyUrl(r);
        try {
            String result = null;
            String cacheKey = null;
            String cacheData = null;
            try {
                cacheKey = this.assblyCacheKey(r, params);
                cacheData = preference.getPrefString(context, cacheKey, null);
                this.addLastModifyTimeToParams(cacheData, params);
            }
            catch (Throwable e) {
                L.error(GeneralConfigTool.class, "get cache exception %s", e);
            }
            result = HttpUtil.get(url, params);
            JSONObject jsonResult = new JSONObject(result);
            String code = jsonResult.getString(KEY_CODE);
            if (jsonResult.has(KEY_TIME)) {
                String time = jsonResult.getString(KEY_TIME);
                this.setSrvTime(time);
            }
            if (KEY_CODE_STATUS_SUCCESS.equals(code)) {
                L.verbose(GeneralConfigTool.class, "data is modified", new Object[0]);
                preference.setPrefString(context, cacheKey, result);
            } else if (KEY_CODE_STATUS_NOT_MODIFIED.equals(code)) {
                result = cacheData;
                L.verbose(GeneralConfigTool.class, "data is not modified,so get the cache data [%s]", result);
                jsonResult = new JSONObject(result);
            }
            String data = this.parseData(jsonResult, isDecrypt);
            return data;
        }
        catch (Throwable e) {
            L.error(GeneralConfigTool.class, "http get [%s] error! %s", url, e);
            L.error(GeneralConfigTool.class, "exception:%s", e);
            return null;
        }
    }

    private void addLastModifyTimeToParams(String cacheData, Map<String, String> params) throws JSONException {
        String lastModifiedTime;
        JSONObject jsonResult;
        if (!Util.empty(cacheData) && (jsonResult = new JSONObject(cacheData)).has(KEY_LAST_MODIFIED_TIME) && !Util.empty(lastModifiedTime = jsonResult.get(KEY_LAST_MODIFIED_TIME) + "")) {
            if (params == null) {
                params = new HashMap<String, String>();
            }
            params.put(KEY_LAST_MODIFIED_TIME, lastModifiedTime);
        }
    }

    private String assblyUrl(String r) {
        String url = this.URL_CONFIG_SERVER;
        if (r != null) {
            url = url + r;
        }
        return url;
    }

    private String assblyCacheKey(String r, Map<String, String> params) throws Exception {
        StringBuffer key = new StringBuffer();
        key.append(this.URL_CONFIG_SERVER);
        key.append(r == null ? "" : r).append("?");
        if (params != null && params.size() > 0) {
            TreeSet<String> keySet = new TreeSet<String>(params.keySet());
            for (String kk : keySet) {
                key.append(kk).append("=").append(params.get(kk)).append("&");
            }
        }
        return Coder.encryptMD5(key.toString());
    }

    private String parseData(JSONObject jsonResult, boolean isDecrypt) throws Exception {
        if (KEY_CODE_STATUS_SUCCESS.equals(jsonResult.getString(KEY_CODE))) {
            String data = jsonResult.getString(KEY_DATA);
            if (!Util.empty(data)) {
                if (isDecrypt) {
                    String time = jsonResult.getString(KEY_TIME);
                    String key = time + KEY_MAGIC;
                    this.setSrvTime(time);
                    key = Coder.encryptMD5(key).toLowerCase().substring(0, 8);
                    L.verbose(GeneralConfigTool.class, "key is %s", key);
                    L.verbose(GeneralConfigTool.class, "data before decrypt  is %s", data);
                    data = Coder.decryptDES(data, key);
                    L.verbose(GeneralConfigTool.class, "data after decrypt  is %s", data);
                } else {
                    L.verbose(GeneralConfigTool.class, "data without decrypt  is %s", data);
                }
            }
            return data;
        }
        L.error(GeneralConfigTool.class, "http get fail! code is %s,msg is %s", jsonResult.getString(KEY_CODE), jsonResult.getString(KEY_MSG));
        return null;
    }

    public String getSrvTime() {
        try {
            return DefaultPreference.getPreference().getPrefString(this.mContext, PRFKEY_SRV_TM, null);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void setSrvTime(String time) {
        try {
            String srvTime = this.getSrvTime();
            if (srvTime == null || time != null && Long.parseLong(time) > Long.parseLong(srvTime)) {
                DefaultPreference.getPreference().setPrefString(this.mContext, PRFKEY_SRV_TM, time);
            }
        }
        catch (Throwable e) {
            L.error(this, e.getMessage(), new Object[0]);
        }
    }
}

