/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.obj;

import com.yy.hiidostatis.defs.obj.IJsonSerialize;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.json.JSONException;
import org.json.JSONObject;

public class Counter
implements IJsonSerialize,
Cloneable {
    private int scode;
    private String uri;
    private String counterName;
    private long value;
    private int invokeCount;

    public Counter(int scode, String uri, String counterName) {
        this.scode = scode;
        this.uri = uri;
        this.counterName = counterName;
    }

    public int getInvokeCount() {
        return this.invokeCount;
    }

    public long getValue() {
        return this.value;
    }

    public synchronized void count(long value, int invoke) {
        this.value += value;
        this.invokeCount += invoke;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject toJson() {
        long in;
        long va;
        Counter counter = this;
        synchronized (counter) {
            va = this.value;
            in = this.invokeCount;
        }
        if (va == 0L && in == 0L) {
            return null;
        }
        try {
            JSONObject obj = new JSONObject();
            obj.put("scode", this.scode);
            obj.put("uri", (Object)URLEncoder.encode(this.uri, "utf-8"));
            obj.put("counterName", (Object)URLEncoder.encode(this.counterName, "utf-8"));
            obj.put("value", va);
            obj.put("invokecount", (int)in);
            return obj;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getKey() {
        return String.format("%d&%s&%s", this.scode, this.uri, this.counterName);
    }

    protected Object clone() {
        Counter counter = new Counter(this.scode, this.uri, this.counterName);
        counter.value = this.value;
        counter.invokeCount = this.invokeCount;
        return counter;
    }
}

