/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util.log;

import android.content.Context;
import android.os.Process;
import android.util.Log;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.log.IBaseStatisLogWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;

public class L {
    private static final String PREFIX_FORMAT = "[%s]";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static String mTag = "HdLog";
    private static String mPrefix = String.format("[%s]", mTag);
    private static IBaseStatisLogWriter sLogWriter;
    private static boolean mIsLogOn;
    private static boolean mIsDebugSdConfig;
    private static boolean mIsLogOnSdConfig;

    public static String getTag() {
        return mTag;
    }

    protected static String getPreFix() {
        return mPrefix;
    }

    private static String getLogText(Object obj, String format, Object ... args) {
        String msg = Util.formatStr(format, args);
        int line = L.getCallerLineNumber();
        String filename = L.getCallerFilename();
        String logText = L.msgForTextLog(obj, filename, line, msg);
        return logText;
    }

    public static void brief(String format, Object ... args) {
        if (!L.isLogOn()) {
            return;
        }
        try {
            String logText = null;
            if (L.outputDebug()) {
                logText = String.format("%s %s", L.getPreFix(), L.getLogText(null, format, args));
                Log.d((String)L.getTag(), (String)logText);
            }
        }
        catch (Throwable e) {
            Log.e((String)L.getTag(), (String)("Log.brief exception=" + e));
        }
    }

    public static void verbose(Object obj, String format, Object ... args) {
        if (!L.isLogOn()) {
            return;
        }
        try {
            String logText = null;
            if (L.outputDebug()) {
                logText = String.format("%s %s", L.getPreFix(), L.getLogText(obj, format, args));
                Log.d((String)L.getTag(), (String)logText);
            }
        }
        catch (Throwable e) {
            Log.e((String)L.getTag(), (String)("Log.verbose exception=" + e));
        }
    }

    public static void debug(Object obj, String format, Object ... args) {
        if (!L.isLogOn()) {
            return;
        }
        try {
            String logText = null;
            if (L.outputDebug()) {
                logText = String.format("%s %s", L.getPreFix(), L.getLogText(obj, format, args));
                Log.i((String)L.getTag(), (String)logText);
                L.writeLog(logText, 1);
            }
        }
        catch (Throwable e) {
            Log.e((String)L.getTag(), (String)("Log.debug exception=" + e));
        }
    }

    public static void info(Object obj, String format, Object ... args) {
        if (!L.isLogOn()) {
            return;
        }
        try {
            String logText = String.format("%s %s", L.getPreFix(), L.getLogText(obj, format, args));
            Log.i((String)L.getTag(), (String)logText);
            L.writeLog(logText, 2);
        }
        catch (Throwable e) {
            Log.e((String)L.getTag(), (String)("Log.info exception=" + e));
        }
    }

    public static void infoOn(Object obj, String format, Object ... args) {
        try {
            String logText = String.format("%s %s", L.getPreFix(), L.getLogText(obj, format, args));
            Log.i((String)L.getTag(), (String)logText);
            L.writeLog(logText, 2);
        }
        catch (Throwable e) {
            Log.e((String)L.getTag(), (String)("Log.info exception=" + e));
        }
    }

    public static void warn(Object obj, String format, Object ... args) {
        if (!L.isLogOn()) {
            return;
        }
        try {
            String logText = String.format("%s %s", L.getPreFix(), L.getLogText(obj, format, args));
            Log.w((String)L.getTag(), (String)logText);
            L.writeLog(logText, 3);
        }
        catch (Throwable e) {
            Log.e((String)L.getTag(), (String)("Log.warn exception=" + e));
        }
    }

    public static void warnOn(Object obj, String format, Object ... args) {
        try {
            String logText = String.format("%s %s", L.getPreFix(), L.getLogText(obj, format, args));
            Log.w((String)L.getTag(), (String)logText);
            L.writeLog(logText, 3);
        }
        catch (Throwable e) {
            Log.e((String)L.getTag(), (String)("Log.warn exception=" + e));
        }
    }

    public static void error(Object obj, String format, Object ... args) {
        if (!L.isLogOn()) {
            return;
        }
        try {
            String logText = String.format("%s %s", L.getPreFix(), L.getLogText(obj, format, args));
            logText = L.formatErrorMsg(logText, args);
            Log.e((String)L.getTag(), (String)logText);
            L.writeLog(logText, 4);
        }
        catch (Throwable e) {
            Log.e((String)L.getTag(), (String)("Log.error exception=" + e));
        }
    }

    public static void errorOn(Object obj, String format, Object ... args) {
        try {
            String logText = String.format("%s %s", L.getPreFix(), L.getLogText(obj, format, args));
            logText = L.formatErrorMsg(logText, args);
            Log.e((String)L.getTag(), (String)logText);
            L.writeLog(logText, 4);
        }
        catch (Throwable e) {
            Log.e((String)L.getTag(), (String)("Log.error exception=" + e));
        }
    }

    private static String formatErrorMsg(String logText, Object ... args) {
        if (args.length > 0 && args[args.length - 1] instanceof Throwable) {
            Throwable t = (Throwable)args[args.length - 1];
            logText = L.logToFile(logText, t);
        }
        return logText;
    }

    private static String objClassName(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.getClass().getSimpleName();
    }

    private static String logToFile(String logText, Throwable t) {
        StringWriter sw = new StringWriter();
        sw.write(logText);
        sw.write("\n");
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String errorinfo = sw.toString();
        try {
            pw.close();
            sw.close();
        }
        catch (IOException e) {
            Log.e((String)"L", (String)"", (Throwable)e);
        }
        pw = null;
        sw = null;
        return errorinfo;
    }

    private static String msgForTextLog(Object obj, String filename, int line, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append(msg);
        sb.append("(P:");
        sb.append(Process.myPid());
        sb.append(")");
        sb.append("(T:");
        sb.append(Thread.currentThread().getId());
        sb.append(")");
        sb.append("(C:");
        sb.append(L.objClassName(obj));
        sb.append(")");
        sb.append("at (");
        sb.append(filename);
        sb.append(":");
        sb.append(line);
        sb.append(")");
        String ret = sb.toString();
        sb.setLength(0);
        sb = null;
        return ret;
    }

    private static int getCallerLineNumber() {
        return Thread.currentThread().getStackTrace()[5].getLineNumber();
    }

    private static String getCallerFilename() {
        return Thread.currentThread().getStackTrace()[5].getFileName();
    }

    public static void writeLog(String s, int type) {
        try {
            if (sLogWriter != null) {
                sLogWriter.write(type, L.formatLog(type, s));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static String formatLog(int type, String s) {
        return String.format("%s\t%8s\t%s\t%s", L.getTag(), L.getTypeName(type), Util.formatDate(DATE_FORMAT, System.currentTimeMillis()), s);
    }

    private static String getTypeName(int type) {
        String typeName = "";
        switch (type) {
            case 1: {
                typeName = "DEBUG";
                break;
            }
            case 4: {
                typeName = "ERROR";
                break;
            }
            case 2: {
                typeName = "INFO";
                break;
            }
            case 3: {
                typeName = "WARN";
                break;
            }
            default: {
                typeName = "UNKNOWN";
            }
        }
        return typeName;
    }

    public static void setLogSetting(IBaseStatisLogWriter logWriter) {
        sLogWriter = logWriter;
    }

    public static void setLogTag(String logTag) {
        if (logTag != null) {
            mTag = logTag;
            mPrefix = String.format(PREFIX_FORMAT, mTag);
        }
    }

    public static boolean outputDebug() {
        return mIsDebugSdConfig || sLogWriter != null && sLogWriter.outputDebug();
    }

    public static void setLogOn(boolean logOn) {
        mIsLogOn = logOn;
    }

    public static boolean isLogOn() {
        return mIsLogOnSdConfig || mIsLogOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLogConfig(Context context) {
        FileInputStream fis = null;
        try {
            String configPath = null;
            StringBuffer sb = new StringBuffer();
            if (context.getExternalCacheDir() == null) {
                return;
            }
            sb.append(context.getExternalFilesDir(null).getAbsolutePath());
            sb.append(File.separator);
            sb.append("hdconfig.txt");
            configPath = sb.toString();
            sb.setLength(0);
            sb = null;
            File f = new File(configPath);
            if (!f.exists()) {
                L.infoOn(L.class, "initLogConfig is empty", new Object[0]);
                return;
            }
            Properties prop = new Properties();
            fis = new FileInputStream(f);
            prop.load(fis);
            mIsDebugSdConfig = Boolean.parseBoolean(prop.getProperty("isDebug"));
            mIsLogOnSdConfig = Boolean.parseBoolean(prop.getProperty("isLogOn"));
            L.infoOn(L.class, "initLogConfig,mIsDebugSdConfig=%b,mIsLogOnSdConfig=%b", mIsDebugSdConfig, mIsLogOnSdConfig);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    Log.e((String)"L", (String)"", (Throwable)e);
                }
            }
        }
    }

    static {
        mIsLogOn = false;
        mIsDebugSdConfig = false;
        mIsLogOnSdConfig = false;
    }
}

