/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.obj;

import com.yy.hiidostatis.inner.util.NumberUtil;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.cipher.AesCipher;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class SendCell {
    private static final String AES_KEY = "*&Hjkfa{{07";
    public static final int RANDOM_LEN = 10000;
    private String content;
    private int retry;
    private long expire;
    private long timestamp;
    private long id;

    public SendCell(String content, long expire) {
        this(0L, content, expire, 0, System.currentTimeMillis());
    }

    public SendCell(long id2, String content, long expire, int retry, long timestamp) {
        this.content = content;
        this.retry = retry;
        this.expire = expire;
        this.timestamp = timestamp;
        this.id = id2 == 0L ? this.createId() : id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToFile(File dir) {
        File f = this.randomFile(dir);
        if (f.exists()) {
            return true;
        }
        FileOutputStream outputStream = null;
        try {
            byte[] bs = new AesCipher((f.getName() + AES_KEY).getBytes()).encrypt(this.content.getBytes("utf-8"));
            outputStream = new FileOutputStream(f);
            outputStream.write(NumberUtil.getBytes(this.timestamp));
            outputStream.write(NumberUtil.getBytes(this.expire));
            outputStream.write(NumberUtil.getBytes(this.retry));
            outputStream.write(bs);
            outputStream.flush();
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public void deleteFile(File dir) {
        if (this.id == 0L) {
            return;
        }
        String fold = dir.getAbsolutePath();
        StringBuilder builder = new StringBuilder(fold.length() + 25);
        String fn = builder.append(fold).append("/").append(this.id).append(".sec").toString();
        boolean b = new File(fn).delete();
    }

    public static long parseId(String fileName) {
        try {
            if (fileName.endsWith(".sec")) {
                long id2 = Long.parseLong(fileName.substring(0, fileName.length() - 4));
                return id2;
            }
        }
        catch (Throwable e) {
            L.error("", e.getMessage(), new Object[0]);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendCell loadFromFile(File file) {
        FileInputStream inputStream = null;
        try {
            SendCell cell;
            inputStream = new FileInputStream(file);
            byte[] data = Util.readInputStream(inputStream);
            long id2 = SendCell.parseId(file.getName());
            long time = NumberUtil.getLong(data, 0);
            long expire = NumberUtil.getInt(data, 8);
            int retry = NumberUtil.getInt(data, 16);
            AesCipher ac = new AesCipher((file.getName() + AES_KEY).getBytes());
            byte[] dec = ac.decrypt(data, 20, data.length - 20);
            String content = new String(dec, "utf-8").trim();
            SendCell sendCell = cell = new SendCell(id2, content, expire, retry, time);
            return sendCell;
        }
        catch (Throwable e) {
            L.error("", e.getMessage(), new Object[0]);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private long createId() {
        long r = (this.timestamp + this.expire * 1000L) * 10000L + (long)(Math.random() * 10000.0);
        return r;
    }

    private File randomFile(File dir) {
        String fold = dir.getAbsolutePath();
        StringBuilder builder = new StringBuilder(fold.length() + 25);
        String fn = builder.append(fold).append("/").append(this.id).append(".sec").toString();
        File file = new File(fn);
        return file;
    }

    public String getContent() {
        return this.content;
    }

    public int getRetry() {
        return this.retry;
    }

    public int retryIncrease() {
        int i = this.retry;
        this.retry = ++i;
        return this.retry;
    }

    public long getExpire() {
        return this.expire;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getId() {
        return this.id;
    }
}

