/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util;

import android.os.Handler;
import com.yy.hiidostatis.inner.util.log.L;

public class Counter
implements Runnable {
    private int counter;
    private static final Callback NONE = new Callback(){

        @Override
        public void onCount(int a) {
        }
    };
    private Callback mCallback = NONE;
    private final long INTERVAL;
    private boolean mRunning = false;
    private final int STEP;
    private final Handler mHandler;

    public Counter(Handler h, int from, long interval, boolean inc) {
        this.mHandler = h;
        this.counter = from;
        this.INTERVAL = interval;
        this.STEP = inc ? 1 : -1;
        L.verbose(this, "create counter, from %d, interval %d, step %d", this.counter, this.INTERVAL, this.STEP);
    }

    public Counter setCounter(int cnt) {
        this.counter = cnt;
        L.verbose(this, "set to %d", cnt);
        return this;
    }

    public Counter reset() {
        return this.setCounter(0);
    }

    public Counter toggle(boolean start) {
        return start ? this.start(0L) : this.stop();
    }

    public Counter start(long delayedMillis) {
        this.mHandler.removeCallbacks((Runnable)this);
        this.mRunning = true;
        this.mHandler.postDelayed((Runnable)this, delayedMillis);
        L.verbose(this, "counter start,hashCode =[%d],mRunning = %b", this.hashCode(), this.mRunning);
        return this;
    }

    public Counter stop() {
        this.mHandler.removeCallbacks((Runnable)this);
        this.mRunning = false;
        L.verbose(this, "counter stop ,hashCode =[%d],mRunning = %b", this.hashCode(), this.mRunning);
        return this;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback == null ? NONE : callback;
    }

    public int count() {
        return this.counter;
    }

    public boolean running() {
        return this.mRunning;
    }

    @Override
    public void run() {
        L.verbose(this, "counter run ,hashCode =[%d],mRunning = %b", this.hashCode(), this.mRunning);
        if (this.mRunning) {
            this.mCallback.onCount(this.counter);
            this.counter += this.STEP;
            this.mHandler.postDelayed((Runnable)this, this.INTERVAL);
        }
    }

    public long getInterval() {
        return this.INTERVAL;
    }

    public static interface Callback {
        public void onCount(int var1);
    }
}

