/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util;

import com.yy.hiidostatis.inner.util.cipher.Coder;
import com.yy.hiidostatis.inner.util.log.L;

public class InsideMode {
    private static boolean encriptIMEI = false;
    private static boolean encriptIMSI = false;
    private static boolean encriptMAC = false;
    private static EncriptType encriptType = EncriptType.NONE;
    private static HostApp hostApp = HostApp.NONE;

    private static String encript(String data) {
        if (data == null || data.isEmpty()) {
            return data;
        }
        try {
            String ret;
            switch (encriptType) {
                case NONE: {
                    ret = data;
                    break;
                }
                case MD5: {
                    ret = Coder.encryptMD5(data);
                    break;
                }
                case SHA256: {
                    ret = Coder.sha256Encrypt(data);
                    break;
                }
                case DOUBLE_MD5: {
                    ret = Coder.encryptMD5(Coder.encryptMD5(data));
                    break;
                }
                default: {
                    ret = data;
                }
            }
            return ret;
        }
        catch (Throwable e) {
            L.error(InsideMode.class, "encript", e);
            return "";
        }
    }

    static String safeIMEI(String imei) {
        if (encriptIMEI) {
            return InsideMode.encript(imei);
        }
        return imei;
    }

    static String safeIMSI(String imsi) {
        if (encriptIMSI) {
            return InsideMode.encript(imsi);
        }
        return imsi;
    }

    static String safeMac(String mac) {
        if (encriptMAC) {
            return InsideMode.encript(mac);
        }
        return mac;
    }

    public static boolean isSafeMac() {
        return encriptMAC;
    }

    public static void initHostApp(HostApp app) {
        switch (app) {
            case NONE: {
                encriptIMEI = false;
                encriptIMSI = false;
                encriptMAC = false;
                encriptType = EncriptType.NONE;
                break;
            }
            case MI: {
                encriptIMEI = true;
                encriptIMSI = true;
                encriptMAC = false;
                encriptType = EncriptType.SHA256;
                break;
            }
            case VIVO: {
                encriptIMEI = true;
                encriptIMSI = true;
                encriptMAC = true;
                encriptType = EncriptType.DOUBLE_MD5;
                break;
            }
            case MEIPAI: {
                encriptIMEI = true;
                encriptIMSI = true;
                encriptMAC = false;
                encriptType = EncriptType.SHA256;
            }
        }
    }

    public static enum HostApp {
        NONE,
        MI,
        VIVO,
        MEIPAI;

    }

    static enum EncriptType {
        NONE,
        MD5,
        DOUBLE_MD5,
        SHA256;

    }
}

