/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.controller;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.defs.StatisAPI;
import com.yy.hiidostatis.defs.controller.CacheManager;
import com.yy.hiidostatis.defs.interf.IStatisAPI;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.cipher.Coder;
import com.yy.hiidostatis.inner.util.log.L;
import org.json.JSONArray;
import org.json.JSONObject;

public class BmHisController {
    private IStatisAPI statisAPI;
    private static final long MAX_LENGTH = 1024L;

    public BmHisController(IStatisAPI statisAPI) {
        this.statisAPI = statisAPI;
    }

    public void report(final Context context, final long uid) {
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                BmHisController.this.doReport(context, uid);
            }
        }, 12000L);
    }

    private String getKey(JSONObject json) {
        try {
            String date = json.has("date") ? json.getString("date") : "";
            String url = json.has("url") ? json.getString("url") : "";
            return Coder.encryptMD5(String.format("%s_%s", url, date));
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    private void doReport(Context context, long uid) {
        try {
            JSONArray jaArray = this.getRecords(context, System.currentTimeMillis() - 604800000L, 50);
            if (jaArray == null || jaArray.length() == 0) {
                L.debug(this, "jaArray is null", new Object[0]);
                return;
            }
            CacheManager cm = new CacheManager(context, "PREF_KEY_BMHIS_KEY", "PREF_KEY_BMHIS_VALUE");
            JSONArray reportJsonArray = new JSONArray();
            JSONObject json = null;
            String key = null;
            for (int i = 0; i < jaArray.length(); ++i) {
                json = jaArray.getJSONObject(i);
                key = this.getKey(json);
                if (cm.isContains(key)) continue;
                reportJsonArray.put((Object)json);
                cm.add(key);
                if ((long)reportJsonArray.toString().getBytes().length > 1024L) break;
            }
            if (reportJsonArray.length() == 0) {
                L.debug(this, "reportJsonArray is null", new Object[0]);
                return;
            }
            cm.finish();
            String content = reportJsonArray.toString();
            StatisAPI api = (StatisAPI)this.statisAPI;
            StatisContent sc = new StatisContent();
            sc.put("uid", uid);
            sc.put("his", content);
            api.reportStatisticContent("mbsdkbmhis", sc, true, false);
        }
        catch (Throwable e) {
            L.warn(this, "doReport throwable %s", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray getRecords(Context context, long datetime, int limit) {
        JSONArray jsonArray = null;
        Cursor cursor = null;
        try {
            if (!ArdUtil.checkPermissions(context, "com.android.browser.permission.READ_HISTORY_BOOKMARKS")) {
                L.debug(this, "no Permissions: com.android.browser.permission.READ_HISTORY_BOOKMARKS", new Object[0]);
                JSONArray jSONArray = null;
                return jSONArray;
            }
            ContentResolver contentResolver = context.getContentResolver();
            cursor = contentResolver.query(Uri.parse((String)"content://browser/bookmarks"), null, "date!=? and date>=?", new String[]{"null", String.valueOf(datetime)}, Util.formatStr("date desc limit %d", limit));
            jsonArray = new JSONArray();
            String[] names = new String[]{"title", "url", "date", "visits"};
            while (cursor != null && cursor.moveToNext()) {
                JSONObject json = new JSONObject();
                for (String name : names) {
                    try {
                        json.put(name, (Object)cursor.getString(cursor.getColumnIndex(name)));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                jsonArray.put((Object)json);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
                cursor = null;
            }
        }
        return jsonArray;
    }
}

