/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.util;

import java.util.ArrayList;

public class JSONTools {
    public static String formatJson(String json, String fillStringUnit) {
        String token;
        if (json == null || json.trim().length() == 0) {
            return null;
        }
        int fixedLenth = 0;
        ArrayList<String> tokenList = new ArrayList<String>();
        String jsonTemp = json;
        while (jsonTemp.length() > 0) {
            token = JSONTools.getToken(jsonTemp);
            jsonTemp = jsonTemp.substring(token.length());
            token = token.trim();
            tokenList.add(token);
        }
        for (int i = 0; i < tokenList.size(); ++i) {
            token = (String)tokenList.get(i);
            int length = token.getBytes().length;
            if (length <= fixedLenth || i >= tokenList.size() - 1 || !((String)tokenList.get(i + 1)).equals(":")) continue;
            fixedLenth = length;
        }
        StringBuilder buf = new StringBuilder();
        int count = 0;
        for (int i = 0; i < tokenList.size(); ++i) {
            String nextToken;
            String token2 = (String)tokenList.get(i);
            if (token2.equals(",")) {
                buf.append(token2);
                JSONTools.doFill(buf, count, fillStringUnit);
                continue;
            }
            if (token2.equals(":")) {
                buf.append("").append(token2).append(" ");
                continue;
            }
            if (token2.equals("{")) {
                nextToken = (String)tokenList.get(i + 1);
                if (nextToken.equals("}")) {
                    ++i;
                    buf.append("{ }");
                    continue;
                }
                buf.append(token2);
                JSONTools.doFill(buf, ++count, fillStringUnit);
                continue;
            }
            if (token2.equals("}")) {
                JSONTools.doFill(buf, --count, fillStringUnit);
                buf.append(token2);
                continue;
            }
            if (token2.equals("[")) {
                nextToken = (String)tokenList.get(i + 1);
                if (nextToken.equals("]")) {
                    ++i;
                    buf.append("[ ]");
                    continue;
                }
                buf.append(token2);
                JSONTools.doFill(buf, ++count, fillStringUnit);
                continue;
            }
            if (token2.equals("]")) {
                JSONTools.doFill(buf, --count, fillStringUnit);
                buf.append(token2);
                continue;
            }
            buf.append(token2);
        }
        return buf.toString();
    }

    private static String getToken(String json) {
        StringBuilder buf = new StringBuilder();
        boolean isInYinHao = false;
        while (json.length() > 0) {
            String token = json.substring(0, 1);
            json = json.substring(1);
            if (!isInYinHao && (token.equals(":") || token.equals("{") || token.equals("}") || token.equals("[") || token.equals("]") || token.equals(","))) {
                if (buf.toString().trim().length() != 0) break;
                buf.append(token);
                break;
            }
            if (token.equals("\\")) {
                buf.append(token);
                buf.append(json.substring(0, 1));
                json = json.substring(1);
                continue;
            }
            if (token.equals("\"")) {
                buf.append(token);
                if (isInYinHao) break;
                isInYinHao = true;
                continue;
            }
            buf.append(token);
        }
        return buf.toString();
    }

    private static void doFill(StringBuilder buf, int count, String fillStringUnit) {
        buf.append("\n");
        for (int i = 0; i < count; ++i) {
            buf.append(fillStringUnit);
        }
    }
}

