/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.thread;

import com.yy.gslbsdk.thread.ThreadInfo;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.util.HashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolMgr {
    private static ThreadPoolMgr mThreadPoolMgr = null;
    private ITaskExecutor mExecutorSvc;
    private HashMap<String, String> mThreadName = new HashMap();
    private boolean mReleaseAble;

    public static ThreadPoolMgr getInstance() {
        if (mThreadPoolMgr == null) {
            mThreadPoolMgr = new ThreadPoolMgr();
        }
        return mThreadPoolMgr;
    }

    public void create(ITaskExecutor executor) {
        if (executor == null) {
            this.create(GlobalTools.THREAD_POOL_MIN, GlobalTools.THREAD_POOL_MAX);
            LogTools.printDebug("initThreadPool..." + GlobalTools.THREAD_POOL_MIN + "/" + GlobalTools.THREAD_POOL_MAX);
        } else {
            this.mReleaseAble = false;
            this.mExecutorSvc = executor;
        }
    }

    public void create(int min, int max) {
        this.mReleaseAble = true;
        this.mExecutorSvc = new CustomThreadPoolExecutor(min, max);
    }

    public int getPoolSize() {
        return this.mExecutorSvc.getPoolSize();
    }

    public int getActiveCount() {
        return this.mExecutorSvc.getActiveCount();
    }

    public String dump() {
        String ret = "threadpool dump: ";
        ret = this.mExecutorSvc.isShutdown() || this.mExecutorSvc.isTerminated() ? "thread pool is shutdown" : " poolSize=" + this.getPoolSize() + " activeCount=" + this.getActiveCount();
        return ret;
    }

    public synchronized int addTask(ThreadInfo task) {
        if (task == null) {
            return 5;
        }
        task.setThreadEndOper(new ThreadInfo.ThreadEndOper(){

            @Override
            public void handleOper(String name) {
                ThreadPoolMgr.this.mThreadName.remove(name);
            }
        });
        if (this.mThreadName.containsKey(task.getThreadName())) {
            return 0;
        }
        try {
            if (this.mExecutorSvc.addTask(task)) {
                this.mThreadName.put(task.getThreadName(), null);
                return 0;
            }
        }
        catch (Exception e) {
            LogTools.printError("ThreadPoolMgr.addTask() exception:" + e.getMessage());
        }
        return 8;
    }

    public void stop(long timeoutMs) {
        if (!this.mReleaseAble) {
            return;
        }
        this.mExecutorSvc.shutdownNow(timeoutMs);
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory() {
            this.group = Thread.currentThread().getThreadGroup();
            this.namePrefix = "dnspool-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private static class CustomThreadPoolExecutor
    implements ITaskExecutor {
        private ThreadPoolExecutor mExcutorSvc;

        public CustomThreadPoolExecutor(int min, int max) {
            this.mExcutorSvc = new ThreadPoolExecutor(min, max, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultThreadFactory());
            this.mExcutorSvc.prestartAllCoreThreads();
        }

        @Override
        public boolean addTask(Runnable task) {
            try {
                this.mExcutorSvc.execute(task);
            }
            catch (RejectedExecutionException e) {
                LogTools.printWarning(e);
                return false;
            }
            return true;
        }

        @Override
        public int getPoolSize() {
            return this.mExcutorSvc.getPoolSize();
        }

        @Override
        public int getActiveCount() {
            return this.mExcutorSvc.getActiveCount();
        }

        @Override
        public boolean isShutdown() {
            return this.mExcutorSvc.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.mExcutorSvc.isTerminated();
        }

        @Override
        public void shutdownNow(long timeoutMs) {
            try {
                this.mExcutorSvc.shutdownNow();
                this.mExcutorSvc.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LogTools.printWarning(e);
            }
        }
    }

    public static interface ITaskExecutor {
        public boolean addTask(Runnable var1);

        public int getPoolSize();

        public int getActiveCount();

        public boolean isShutdown();

        public boolean isTerminated();

        public void shutdownNow(long var1);
    }
}

