/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.protocol;

import com.yy.gslbsdk.protocol.DnsInfo;
import com.yy.gslbsdk.util.LogTools;
import java.net.InetAddress;
import java.util.LinkedList;

public class LocalDNSProtocolMgr {
    public static DnsInfo requestProtocol(String host) {
        LinkedList<String> ipList = new LinkedList<String>();
        try {
            InetAddress[] addrArray = InetAddress.getAllByName(host);
            if (addrArray != null && addrArray.length > 0) {
                for (InetAddress addr : addrArray) {
                    byte[] byteAddr = addr.getAddress();
                    if (byteAddr == null || byteAddr.length != 4) continue;
                    ipList.add(addr.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            LogTools.printError("LocalDNSProtocolMgr.requestProtocol() exception:" + e.getMessage());
        }
        if (ipList.isEmpty()) {
            return null;
        }
        DnsInfo dnsInfo = new DnsInfo();
        dnsInfo.setHost(host);
        dnsInfo.setIps(ipList);
        dnsInfo.setTtl(0);
        return dnsInfo;
    }
}

