/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.device;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.yy.gslbsdk.GslbEvent;
import com.yy.gslbsdk.util.LogTools;

public class NetStatusReceiver {
    private boolean mRegistered = false;
    private ChangeNetworkInter mChangeNetworkInter = null;
    private BroadcastReceiver mNetReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.net.conn.CONNECTIVITY_CHANGE") && NetStatusReceiver.this.mRegistered) {
                Thread thd = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (!NetStatusReceiver.this.mRegistered) {
                            return;
                        }
                        if (NetStatusReceiver.this.mChangeNetworkInter != null) {
                            NetStatusReceiver.this.mChangeNetworkInter.onNetStateChanged();
                        }
                    }
                });
                thd.start();
            }
        }
    };

    public NetStatusReceiver(ChangeNetworkInter inter) {
        this.mChangeNetworkInter = inter;
    }

    public void register(Context context) {
        if (context != null && !this.mRegistered) {
            IntentFilter mFilter = new IntentFilter();
            mFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            try {
                context.registerReceiver(this.mNetReceiver, mFilter);
                this.mRegistered = true;
            }
            catch (Exception e) {
                LogTools.printWarning(e);
                GslbEvent.INSTANCE.onMessage(String.format("register net receiver failed! error: %s", e.getMessage()));
            }
        }
    }

    public void unregister(Context context) {
        if (context != null && this.mRegistered) {
            context.unregisterReceiver(this.mNetReceiver);
            this.mRegistered = false;
        }
    }

    public static interface ChangeNetworkInter {
        public void onNetStateChanged();
    }
}

