/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.control;

public class NetworkStatus {
    public static final int IP_V4 = 1;
    public static final int IP_V6 = 2;
    public static final int STATUS_IP_V_NONE = 0;
    public static final int STATUS_IP_V4_ONLY = 1;
    public static final int STATUS_IP_V6_ONLY = 2;
    public static final int STATUS_IP_V4_AND_V6 = 3;
    private static NetworkStatus sInstance = new NetworkStatus();
    private boolean mEnableV6 = true;
    private int mStatus = 0;

    private NetworkStatus() {
    }

    private static NetworkStatus getInstance() {
        if (sInstance == null) {
            sInstance = new NetworkStatus();
        }
        return sInstance;
    }

    public static NetworkStatus getInstanceClone() {
        return NetworkStatus.getInstance().clone();
    }

    public static void updateEnableV6(boolean enable) {
        NetworkStatus.getInstance().mEnableV6 = enable;
    }

    public static void updateStatus(int status) {
        NetworkStatus.getInstance().mStatus = status;
    }

    public boolean isEnableV6() {
        return this.mEnableV6;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public boolean canV6() {
        boolean supportV6 = (this.mStatus & 2) > 0;
        boolean statusIpv6Only = this.mStatus == 2;
        return statusIpv6Only || this.mEnableV6 && supportV6;
    }

    public boolean canV4() {
        boolean supportV4 = (this.mStatus & 1) > 0;
        boolean statusIpv4Only = this.mStatus == 1;
        return statusIpv4Only || supportV4 || this.mStatus == 0;
    }

    public NetworkStatus clone() {
        NetworkStatus status = new NetworkStatus();
        status.mEnableV6 = this.mEnableV6;
        status.mStatus = this.mStatus;
        return status;
    }

    public String toString() {
        return String.format("[EnableV6=%s, Status=%d]", this.mEnableV6 ? "true" : "false", this.mStatus);
    }
}

