/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.youtufacelive.tools;

import android.app.Activity;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.Window;
import android.view.WindowManager;
import com.tencent.youtuface.DataPack;
import com.tencent.youtuface.ImgLandmarks;
import com.tencent.youtuface.Timeval;
import com.tencent.youtufacelive.model.YTDataPack;
import com.tencent.youtufacelive.model.YTImgLandMarks;
import com.tencent.youtufacelive.tools.FileUtils;
import com.tencent.youtufacelive.tools.YTFaceLiveLogger;
import com.tencent.youtulivecheck.YoutuLiveCheck;
import com.webank.normal.tools.WLogger;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class YTUtils {
    private static String a;
    private static String b;
    private static String c;

    public static void prepareMatrix(Matrix matrix, boolean bl, int n, int n2, int n3) {
        YTFaceLiveLogger.i("YTUtils", "prepareMatrix viewWidth=" + n2 + ",viewHeight=" + n3 + ",displayOrientation=" + n);
        matrix.setScale(bl ? -1.0f : 1.0f, 1.0f);
        matrix.postRotate((float)n);
        matrix.postScale((float)n2 / 2000.0f, (float)n3 / 2000.0f);
        matrix.postTranslate((float)n2 / 2.0f, (float)n3 / 2.0f);
    }

    public static int dip2px(Context context, float f) {
        float f2 = context.getResources().getDisplayMetrics().density;
        return (int)(f * f2 + 0.5f);
    }

    public static Rect trans2ScreenRect(Context context, int n, int n2, Rect rect) {
        float f;
        int n3;
        long l = System.currentTimeMillis();
        Rect rect2 = rect;
        YTFaceLiveLogger.i("YTUtils", "trans2ScreenRect srcRect=" + rect.toString());
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        YTFaceLiveLogger.i("YTUtils", "trans2ScreenRect dm.widthPixels=" + displayMetrics.widthPixels);
        YTFaceLiveLogger.i("YTUtils", "trans2ScreenRect dm.heightPixels=" + displayMetrics.heightPixels);
        YTFaceLiveLogger.i("YTUtils", "trans2ScreenRect previewWidth=" + n);
        YTFaceLiveLogger.i("YTUtils", "trans2ScreenRect previewHeight=" + n2);
        int n4 = displayMetrics.widthPixels;
        int n5 = displayMetrics.heightPixels;
        double d2 = (float)n * 1.0f / (float)n2;
        boolean bl = n4 > n5;
        int n6 = bl ? n4 : n5;
        int n7 = n3 = bl ? n5 : n4;
        if ((double)n6 < (double)n3 * d2) {
            n6 = (int)((double)n3 * d2);
        } else {
            n3 = (int)((double)n6 / d2);
        }
        if (bl) {
            n4 = n6;
            n5 = n3;
        } else {
            n4 = n3;
            n5 = n6;
        }
        YTFaceLiveLogger.d("YTUtils", "trans2ScreenRect aspectRatio=" + d2);
        YTFaceLiveLogger.d("YTUtils", "trans2ScreenRect widthLonger=" + bl);
        YTFaceLiveLogger.d("YTUtils", "trans2ScreenRect screenWidth=" + n4);
        YTFaceLiveLogger.d("YTUtils", "trans2ScreenRect screenHeight=" + n5);
        int n8 = n4;
        int n9 = n5;
        int n10 = n2;
        int n11 = n;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (n10 * n9 > n8 * n11) {
            f = (float)n9 * 1.0f / (float)n11;
            f2 = ((float)n8 - (float)n10 * f) * 0.5f;
        } else {
            f = (float)n8 * 1.0f / (float)n10;
            f3 = ((float)n9 - (float)n11 * f) * 0.5f;
        }
        Rect rect3 = new Rect();
        rect3.set((int)((float)rect.left * f - f2), (int)((float)rect.top * f - f3), (int)((float)rect.right * f), (int)((float)rect.bottom * f));
        YTFaceLiveLogger.d("YTUtils", "scale=" + f);
        YTFaceLiveLogger.d("YTUtils", "dx=" + f2);
        YTFaceLiveLogger.d("YTUtils", "dy=" + f3);
        YTFaceLiveLogger.d("YTUtils", "screenWidth=" + n8);
        YTFaceLiveLogger.d("YTUtils", "screenHeight=" + n9);
        YTFaceLiveLogger.d("YTUtils", "dWidth=" + n10);
        YTFaceLiveLogger.d("YTUtils", "dHeight=" + n11);
        YTFaceLiveLogger.d("YTUtils", "dst=" + rect3.toString());
        int n12 = (n4 - displayMetrics.widthPixels) / 2;
        int n13 = (n5 - displayMetrics.heightPixels) / 2;
        rect2.set((int)((float)rect.left * f - (float)n12), (int)((float)rect.top * f - (float)n13), (int)((float)rect.right * f - (float)n12), (int)((float)rect.bottom * f - (float)n13));
        YTFaceLiveLogger.d("YTUtils", "target=" + rect2.toString() + ",time=" + (System.currentTimeMillis() - l));
        return rect2;
    }

    public static Rect trans2ScreenRectForYT(Context context, int n, int n2, Rect rect) {
        Rect rect2 = rect;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        YTFaceLiveLogger.d("YTUtils", "trans2ScreenRectForYT dm.widthPixels=" + displayMetrics.widthPixels);
        YTFaceLiveLogger.d("YTUtils", "trans2ScreenRectForYT dm.heightPixels=" + displayMetrics.heightPixels);
        YTFaceLiveLogger.d("YTUtils", "trans2ScreenRectForYT previewHeight=" + n2);
        float f = (float)displayMetrics.widthPixels * 1.0f / (float)n2;
        rect2.set((int)((float)rect.left * f), (int)((float)rect.top * f), (int)((float)(rect.left + rect.width()) * f), (int)((float)(rect.top + rect.height()) * f));
        return rect2;
    }

    public static Rect translateToMeteringAreaCoordinate(int n, int n2, Rect rect) {
        Rect rect2 = new Rect();
        Matrix matrix = new Matrix();
        YTUtils.prepareMatrix(matrix, true, 90, n, n2);
        matrix.postRotate(0.0f);
        RectF rectF = new RectF((float)rect.left * 1.0f, (float)rect.top * 1.0f, (float)rect.right * 1.0f, (float)rect.bottom * 1.0f);
        YTFaceLiveLogger.d("YTUtils", "translationToMeteringAreaCoordinate old rectF.left=" + rectF.left + ",rectF.top=" + rectF.top + ",rectF.right=" + rectF.right + ",rectF.bottom=" + rectF.bottom);
        Matrix matrix2 = new Matrix();
        matrix.invert(matrix2);
        matrix2.mapRect(rectF);
        YTFaceLiveLogger.d("YTUtils", "translationToMeteringAreaCoordinate new rectF.left=" + rectF.left + ",rectF.top=" + rectF.top + ",rectF.right=" + rectF.right + ",rectF.bottom=" + rectF.bottom);
        rect2.set(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
        return rect2;
    }

    public static void setUserName(String string) {
        a = string + "\n";
    }

    public static void setAppVersion(String string) {
        b = string + "\n";
    }

    public static void setLightDiffTimeInfo(String string) {
        c = string;
    }

    public static String getLightDiffTimeInfo() {
        return c;
    }

    public static YTDataPack translation(DataPack dataPack) {
        YTDataPack yTDataPack = new YTDataPack();
        yTDataPack.setFrame_num(dataPack.frameNum);
        yTDataPack.setLandmark_num(dataPack.landMarkNum);
        try {
            yTDataPack.setLog(b + a + new String(dataPack.log, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        ArrayList<YTImgLandMarks> arrayList = new ArrayList<YTImgLandMarks>();
        for (int i = 0; i < dataPack.videoData.length; ++i) {
            arrayList.add(YTUtils.translation(dataPack.videoData[i]));
        }
        yTDataPack.setVideo_data(arrayList);
        return yTDataPack;
    }

    public static YTImgLandMarks translation(ImgLandmarks imgLandmarks) {
        YTImgLandMarks yTImgLandMarks = new YTImgLandMarks();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.clear();
        YTFaceLiveLogger.d("YTUtils", "imgLandmarks.landMarkX.length: " + imgLandmarks.landMarkX.length);
        for (int i = 0; i < imgLandmarks.landMarkX.length; ++i) {
            arrayList.add(imgLandmarks.landMarkX[i]);
        }
        yTImgLandMarks.setX_list(arrayList);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        arrayList2.clear();
        YTFaceLiveLogger.d("YTUtils", "imgLandmarks.landMarkY.length: " + imgLandmarks.landMarkY.length);
        for (int i = 0; i < imgLandmarks.landMarkY.length; ++i) {
            arrayList2.add(imgLandmarks.landMarkY[i]);
        }
        yTImgLandMarks.setY_list(arrayList2);
        byte[] byArray = Base64.encode((byte[])imgLandmarks.frameBuffer, (int)2);
        String string = new String(byArray);
        yTImgLandMarks.setImage(string);
        return yTImgLandMarks;
    }

    public static void setAppBrightness(Activity activity, int n) {
        YTFaceLiveLogger.d("YTUtils", "setAppBrightness brightness=" + n);
        if (activity == null) {
            WLogger.e((String)"YTUtils", (String)"activity is null! Cant setAppBrightness!");
            return;
        }
        Window window = activity.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.screenBrightness = n == -1 ? -1.0f : (float)(n <= 0 ? 1 : n) / 255.0f;
        window.setAttributes(layoutParams);
    }

    public static Timeval getTimeval() {
        long l = System.nanoTime() / 1000L;
        Timeval timeval = new Timeval(l / 1000000L, (int)(l % 1000000L));
        return timeval;
    }

    public static boolean initModel(Context context) {
        String string;
        String string2;
        String[] stringArray = new String[]{"net_1_bin.rpnproto", "net_1.rpnmodel", "net_2_bin.rpnproto", "net_2.rpnmodel", "net_3_bin.rpnproto", "net_3.rpnmodel"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            string2 = context.getFilesDir().getAbsolutePath();
            string = string2 + "/" + string3;
            FileUtils.copyAsset(context.getAssets(), "detector/" + string3, string);
        }
        String[] stringArray2 = new String[]{"align580.rpdm", "align580_bin.rpdc"};
        for (int i = 0; i < stringArray2.length; ++i) {
            string2 = stringArray2[i];
            string = context.getFilesDir().getAbsolutePath();
            String string4 = string + "/" + string2;
            FileUtils.copyAsset(context.getAssets(), "align/" + string2, string4);
        }
        String string5 = context.getFilesDir().getAbsolutePath();
        string2 = string5 + "/PE.dat";
        FileUtils.copyAsset(context.getAssets(), "PE.dat", string2);
        string = context.getFilesDir().getAbsolutePath();
        boolean bl = YoutuLiveCheck.Init(string + "/");
        return bl;
    }

    public static boolean initModel(Context context, String string) {
        String string2;
        String string3;
        String[] stringArray = new String[]{"net_1_bin.rpnproto", "net_1.rpnmodel", "net_2_bin.rpnproto", "net_2.rpnmodel", "net_3_bin.rpnproto", "net_3.rpnmodel"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            string3 = context.getFilesDir().getAbsolutePath();
            string2 = string3 + "/" + string4;
            FileUtils.copySdCardFile(string + "/detector/" + string4, string2);
        }
        String[] stringArray2 = new String[]{"align580.rpdm", "align580_bin.rpdc"};
        for (int i = 0; i < stringArray2.length; ++i) {
            string3 = stringArray2[i];
            string2 = context.getFilesDir().getAbsolutePath();
            String string5 = string2 + "/" + string3;
            FileUtils.copySdCardFile(string + "/align/" + string3, string5);
        }
        String string6 = context.getFilesDir().getAbsolutePath();
        string3 = string6 + "/PE.dat";
        FileUtils.copySdCardFile(string + "/PE.dat", string3);
        string2 = context.getFilesDir().getAbsolutePath();
        boolean bl = YoutuLiveCheck.Init(string2 + "/");
        return bl;
    }
}

