/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera;

import com.webank.mbank.wecamera.CameraListener;
import com.webank.mbank.wecamera.config.CameraConfig;
import com.webank.mbank.wecamera.hardware.CameraDevice;
import com.webank.mbank.wecamera.hardware.CameraV;
import com.webank.mbank.wecamera.preview.PreviewParameter;
import com.webank.mbank.wecamera.view.CameraView;
import java.util.ArrayList;
import java.util.List;

public class WeCameraListener
implements CameraListener {
    private List<CameraListener> mCameraListeners = new ArrayList<CameraListener>();

    public WeCameraListener register(CameraListener listener) {
        if (listener != null && !this.mCameraListeners.contains(listener)) {
            this.mCameraListeners.add(listener);
        }
        return this;
    }

    public WeCameraListener unregister(CameraListener listener) {
        if (listener != null && this.mCameraListeners.contains(listener)) {
            this.mCameraListeners.remove(listener);
        }
        return this;
    }

    @Override
    public void cameraOpened(CameraDevice cameraDevice, CameraV cameraV, CameraConfig cameraConfigResult) {
        for (int i = 0; i < this.mCameraListeners.size(); ++i) {
            this.mCameraListeners.get(i).cameraOpened(cameraDevice, cameraV, cameraConfigResult);
        }
    }

    @Override
    public void cameraConfigChanged(PreviewParameter previewParameter, CameraV cameraV, CameraConfig cameraConfigResult) {
        for (int i = 0; i < this.mCameraListeners.size(); ++i) {
            this.mCameraListeners.get(i).cameraConfigChanged(previewParameter, cameraV, cameraConfigResult);
        }
    }

    @Override
    public void previewBeforeStart(CameraView cameraView, CameraConfig cameraConfig, PreviewParameter displayFeature, CameraV cameraV) {
        for (int i = 0; i < this.mCameraListeners.size(); ++i) {
            this.mCameraListeners.get(i).previewBeforeStart(cameraView, cameraConfig, displayFeature, cameraV);
        }
    }

    @Override
    public void previewAfterStart(CameraDevice cameraDevice) {
        for (int i = 0; i < this.mCameraListeners.size(); ++i) {
            this.mCameraListeners.get(i).previewAfterStart(cameraDevice);
        }
    }

    @Override
    public void previewBeforeStop(CameraDevice cameraDevice) {
        for (int i = this.mCameraListeners.size() - 1; i >= 0; --i) {
            this.mCameraListeners.get(i).previewBeforeStop(cameraDevice);
        }
    }

    @Override
    public void cameraClosed() {
        for (int i = this.mCameraListeners.size() - 1; i >= 0; --i) {
            this.mCameraListeners.get(i).cameraClosed();
        }
    }
}

