/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.hardware.v1;

import android.hardware.Camera;
import com.webank.mbank.wecamera.error.CameraErrors;
import com.webank.mbank.wecamera.error.CameraException;
import com.webank.mbank.wecamera.hardware.v1.CameraV1;
import com.webank.mbank.wecamera.hardware.v1.V1ParameterOperator;
import com.webank.mbank.wecamera.log.WeCameraLogger;
import java.util.ArrayList;
import java.util.List;

public class V1ParametersOperator {
    private static final String TAG = "V1ParasOperator";
    private List<V1ParameterOperator> mParameterOperators = new ArrayList<V1ParameterOperator>();

    public void addParameterOperator(V1ParameterOperator operator) {
        if (operator != null && !this.mParameterOperators.contains(operator)) {
            this.mParameterOperators.add(operator);
        }
    }

    public void removeParameterOperator(V1ParameterOperator operator) {
        if (operator != null && this.mParameterOperators.contains(operator)) {
            this.mParameterOperators.remove(operator);
        }
    }

    public void operate(CameraV1 cameraV1) {
        Camera camera = cameraV1.camera();
        for (int i = 0; i < this.mParameterOperators.size(); ++i) {
            Camera.Parameters originParameters = camera.getParameters();
            Camera.Parameters parameters = camera.getParameters();
            this.mParameterOperators.get(i).operate(parameters, cameraV1);
            try {
                camera.setParameters(parameters);
                WeCameraLogger.d(TAG, "set config success.", new Object[0]);
                continue;
            }
            catch (Exception e2) {
                WeCameraLogger.w(TAG, "set config failed,rollback:" + originParameters, new Object[0]);
                if (originParameters != null) {
                    camera.setParameters(originParameters);
                }
                CameraErrors.throwError(CameraException.ofDevice(22, "update camera config failed.", e2));
            }
        }
    }
}

