/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.youtufacelive;

import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.tencent.youtuface.DataPack;
import com.tencent.youtuface.YoutuFaceReflect;
import com.tencent.youtufacelive.model.YTDataPack;
import com.tencent.youtufacelive.tools.YTFaceLiveLogger;
import com.tencent.youtufacelive.tools.YTUtils;
import com.webank.mbank.wejson.WeJson;

public class YTPreviewHandlerThread
extends HandlerThread
implements Handler.Callback {
    public static final String KEY_FRAME_DATA = "frame_data";
    public static final String KEY_IMAGE_WIDTH = "width";
    public static final String KEY_IMAGE_HEIGHT = "height";
    public static final String KEY_ANGLE = "angle";
    public static final int MESSAGE_WHAT_PROCESS = 1;
    public static final int MESSAGE_WHAT_END = 2;
    private static long c = System.currentTimeMillis();
    public static boolean mIsOpenDropFrames = true;
    private int d = -1;
    public static int mIndex;
    public static int mDuration;
    public static int mUnit;
    private int e = 1;
    public int a = 0;
    public int b = 0;
    private IUploadListener f;
    private ISetCameraParameterListener g;

    public YTPreviewHandlerThread(String string, IUploadListener iUploadListener, ISetCameraParameterListener iSetCameraParameterListener) {
        super(string);
        this.f = iUploadListener;
        this.g = iSetCameraParameterListener;
    }

    public void setState(int n) {
        this.d = n;
        if (this.d == 0) {
            this.a = YoutuFaceReflect.getInstance().FRGetConfigBegin();
            this.b = YoutuFaceReflect.getInstance().FRGetConfigEnd();
        }
    }

    public void setTag(int n) {
        this.e = n;
    }

    public void setIndex(int n, int n2, int n3) {
        mIndex = n;
        mDuration = n2;
        mUnit = n3;
    }

    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 1: {
                Bundle bundle = message.getData();
                byte[] byArray = (byte[])bundle.getByteArray(KEY_FRAME_DATA).clone();
                int n = bundle.getInt(KEY_IMAGE_WIDTH);
                int n2 = bundle.getInt(KEY_IMAGE_HEIGHT);
                double d2 = bundle.getDouble(KEY_ANGLE);
                if (byArray == null || byArray.length == 0) {
                    YTFaceLiveLogger.e("YTPreviewHandlerThread", "handleMessage frameData == null || frameData.length == 0");
                    return false;
                }
                if (this.d == -1) {
                    YTFaceLiveLogger.i("YTPreviewHandlerThread", "handleMessage MESSAGE_WHAT_PROCESS STATE_PREVIEW:" + Thread.currentThread().getName());
                } else if (this.d == 0) {
                    YTFaceLiveLogger.i("YTPreviewHandlerThread", "handleMessage MESSAGE_WHAT_PROCESS STATE_START configBegin=" + (this.a - 3));
                    YTFaceLiveLogger.i("YTPreviewHandlerThread", "handleMessage MESSAGE_WHAT_PROCESS STATE_START configEnd=" + (this.b + 3));
                    YTFaceLiveLogger.i("YTPreviewHandlerThread", "handleMessage MESSAGE_WHAT_PROCESS STATE_START mIndex=" + mIndex);
                    if (mIndex > this.a - 3 && mIndex < this.b + 3) {
                        if (mIsOpenDropFrames) {
                            long l = System.currentTimeMillis();
                            if (l - c < 50L) {
                                return false;
                            }
                            c = l;
                        }
                        YoutuFaceReflect.getInstance().FRPushYuv(byArray, n, n2);
                        YoutuFaceReflect.getInstance().FRPushCaptureTime(YTUtils.getTimeval());
                    }
                } else if (this.d == 1) {
                    YTFaceLiveLogger.i("YTPreviewHandlerThread", "handleMessage MESSAGE_WHAT_PROCESS STATE_DETECT_DELAY");
                    YoutuFaceReflect.getInstance().FRPushISOImgYuv(byArray, n, n2);
                    YoutuFaceReflect.getInstance().FRPushISOCaptureTime(YTUtils.getTimeval());
                }
                return true;
            }
            case 2: {
                YoutuFaceReflect.getInstance().FRCalcTimeSequence();
                int n = YoutuFaceReflect.getInstance().FRDoDetectionYuvsWithRotation(true, this.e);
                if (n == 0) {
                    DataPack dataPack = YoutuFaceReflect.getInstance().FRGetAGin();
                    WeJson weJson = new WeJson();
                    YTDataPack yTDataPack = YTUtils.translation(dataPack);
                    String string = weJson.toJson((Object)yTDataPack);
                    this.f.onUpload(string, dataPack);
                } else {
                    YTFaceLiveLogger.d("YTPreviewHandlerThread", "lable=" + n);
                    if (n == -1490 || n == -1492 || n == -1497 || n == -1498 || n == -1450) {
                        DataPack dataPack = YoutuFaceReflect.getInstance().FRGetAGin();
                        WeJson weJson = new WeJson();
                        YTDataPack yTDataPack = YTUtils.translation(dataPack);
                        YTFaceLiveLogger.d("YTPreviewHandlerThread", "ytDataPack log: " + String.valueOf(yTDataPack.log));
                        String string = weJson.toJson((Object)yTDataPack);
                        this.f.onError(n, string);
                    } else {
                        this.f.onError(n, null);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static interface ISetCameraParameterListener {
        public void onSetMeteringAreas(Rect var1, float var2, float var3, float var4);

        public void onNoFace();
    }

    public static interface IUploadListener {
        public void onUpload(String var1, DataPack var2);

        public void onError(int var1, String var2);
    }
}

