/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.error;

import android.os.Build;

public class CameraException
extends Throwable {
    public static final String TYPE_API = "type_api";
    public static final String TYPE_FATAL = "type_fatal";
    public static final String TYPE_STATUS = "type_status";
    public static final String TYPE_DEVICE = "type_device";
    public static final String TYPE_NORMAL = "type_normal";
    public static final int CODE_NORMAL = 0;
    public static final int CODE_CAMERA_START = 1;
    public static final int CODE_CAMERA_START_NO_CAN_USE = 11;
    public static final int CODE_CONFIG = 2;
    public static final int CODE_CONFIG_READ_PARAMETER = 21;
    public static final int CODE_CONFIG_UPDATE_PARAMETER = 22;
    public static final int CODE_PREVIEW_START = 3;
    public static final int CODE_PREVIEW_STOP = 8;
    public static final int CODE_PREVIEW_STOP_BEFORE_START = 81;
    public static final int CODE_CAMERA_STOP = 9;
    public static final int CODE_PICTURE = 4;
    public static final int CODE_RECORD = 5;
    public static final int CODE_RECORD_CONFIG = 50;
    public static final int CODE_RECORD_START = 51;
    public static final int CODE_RECORD_STOP = 59;
    public static final int CODE_FACE_DETECTION = 61;
    public static final int CODE_AUTO_FOCUS = 62;
    public static final int CODE_AUTO_FOCUS_BEFORE_CAMERA_START = 621;
    public static final int CODE_ZOOM_SET = 63;
    public static final int CODE_CAMERA_INNER = -1;
    public static final int CODE_RECORD_INNER = -2;
    private int code;
    private String type = "type_normal";
    private static String device = CameraException.getDeviceInfo();

    public static CameraException of(int code, String type, String msg, Throwable cause) {
        return new CameraException(code, msg, cause, type);
    }

    public static CameraException ofApi(int code, String msg) {
        return new CameraException(code, msg, null, TYPE_API);
    }

    public static CameraException ofDevice(int code, String msg) {
        return new CameraException(code, msg, null, TYPE_DEVICE);
    }

    public static CameraException ofStatus(int code, String msg) {
        return new CameraException(code, msg, null, TYPE_STATUS);
    }

    public static CameraException of(int code, String msg) {
        return new CameraException(code, msg, null, TYPE_NORMAL);
    }

    public static CameraException ofApi(int code, String msg, Throwable cause) {
        return new CameraException(code, msg, cause, TYPE_API);
    }

    public static CameraException ofDevice(int code, String msg, Throwable cause) {
        return new CameraException(code, msg, cause, TYPE_DEVICE);
    }

    public static CameraException ofFatal(int code, String msg, Throwable cause) {
        return new CameraException(code, msg, cause, TYPE_FATAL);
    }

    public static CameraException ofStatus(int code, String msg, Throwable cause) {
        return new CameraException(code, msg, cause, TYPE_STATUS);
    }

    public static CameraException of(int code, String msg, Throwable cause) {
        return new CameraException(code, msg, cause, TYPE_NORMAL);
    }

    public static String getDeviceInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("BRAND:").append(Build.BRAND).append("\n");
        builder.append("MODEL:").append(Build.MODEL).append("\n");
        builder.append("SDK_INT:").append(Build.VERSION.SDK_INT).append("\n");
        builder.append("VERSION:").append("v1.0.22").append("\n");
        builder.append("VERSION_CODE:").append(30).append("\n");
        return builder.toString();
    }

    public CameraException(int code, String type) {
        this.code = code;
        this.type = type;
    }

    public CameraException(int code, String message, String type) {
        super(message);
        this.code = code;
        this.type = type;
    }

    public CameraException(int code, String message, Throwable cause, String type) {
        super(message, cause);
        this.code = code;
        this.type = type;
    }

    public CameraException(Throwable cause, String type) {
        super(cause);
        this.type = type;
    }

    public CameraException(int code, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, String type) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.type = type;
        this.code = code;
    }

    public int code() {
        return this.code;
    }

    public String type() {
        return this.type;
    }

    public String message() {
        return super.getMessage();
    }

    public static String device() {
        return device;
    }

    public static void device(String device) {
        CameraException.device = device;
    }
}

