/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.video;

import com.webank.mbank.wecamera.video.CameraRecorder;
import com.webank.mbank.wecamera.video.FutureResult;
import com.webank.mbank.wecamera.video.RecordResult;
import com.webank.mbank.wecamera.video.Result;
import com.webank.mbank.wecamera.video.config.RecordConfig;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;

public class WeAsyncCameraRecorder
implements CameraRecorder {
    private static final String TAG = "WeAsyncCameraRecorder";
    private CameraRecorder mCameraRecorder;
    private ExecutorService mRecordExecutor;

    public WeAsyncCameraRecorder(CameraRecorder cameraRecorder, ExecutorService recordExecutor) {
        this.mCameraRecorder = cameraRecorder;
        this.mRecordExecutor = recordExecutor;
    }

    @Override
    public boolean isRecordStarted() {
        return this.mCameraRecorder.isRecordStarted();
    }

    @Override
    public Result<RecordResult> startRecord(final RecordConfig recordConfig, final String path) {
        FutureTask<RecordResult> startRecordTask = new FutureTask<RecordResult>(new Callable<RecordResult>(){

            @Override
            public RecordResult call() throws Exception {
                RecordResult startResult = WeAsyncCameraRecorder.this.mCameraRecorder.startRecord(recordConfig, path).get();
                return startResult;
            }
        });
        FutureResult<RecordResult> result = new FutureResult<RecordResult>(startRecordTask);
        this.mRecordExecutor.submit(startRecordTask);
        return result;
    }

    @Override
    public Result<RecordResult> stopRecord() {
        FutureTask<RecordResult> stopRecordTask = new FutureTask<RecordResult>(new Callable<RecordResult>(){

            @Override
            public RecordResult call() throws Exception {
                return WeAsyncCameraRecorder.this.mCameraRecorder.stopRecord().get();
            }
        });
        this.mRecordExecutor.submit(stopRecordTask);
        return new FutureResult<RecordResult>(stopRecordTask);
    }

    @Override
    public Result<RecordResult> cancelRecord() {
        FutureTask<RecordResult> cancelRecordTask = new FutureTask<RecordResult>(new Callable<RecordResult>(){

            @Override
            public RecordResult call() throws Exception {
                return WeAsyncCameraRecorder.this.mCameraRecorder.cancelRecord().get();
            }
        });
        this.mRecordExecutor.submit(cancelRecordTask);
        return new FutureResult<RecordResult>(cancelRecordTask);
    }
}

