/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.video;

import android.os.Handler;
import android.os.HandlerThread;
import com.webank.mbank.wecamera.log.WeCameraLogger;
import com.webank.mbank.wecamera.utils.WeUI;
import com.webank.mbank.wecamera.video.CameraRecorder;
import com.webank.mbank.wecamera.video.RecordCancelListener;
import com.webank.mbank.wecamera.video.RecordCanceler;
import com.webank.mbank.wecamera.video.RecordController;
import com.webank.mbank.wecamera.video.RecordListener;
import com.webank.mbank.wecamera.video.RecordResult;
import com.webank.mbank.wecamera.video.RecordStartListener;
import com.webank.mbank.wecamera.video.RecordStopListener;
import com.webank.mbank.wecamera.video.RecordStopper;
import com.webank.mbank.wecamera.video.Result;
import com.webank.mbank.wecamera.video.config.RecordConfig;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;

public class WeRecordController
implements RecordController {
    private static final String TAG = "WeRecordController";
    public static final int INTERVAL_TIME = 1000;
    private ExecutorService mRecordExecutor;
    private ExecutorService mCallbackExecutor;
    private CameraRecorder mCameraRecorder;
    private Result<RecordResult> mStartResult;
    private FutureTask<RecordResult> stopTask;
    private CountDownLatch mRecordFinishLatch = new CountDownLatch(1);
    private FutureTask<RecordResult> mCancelTask;
    private RecordListener mRecordListener;
    private HandlerThread mHandlerThread;
    private Handler mHandler;

    public WeRecordController(Result<RecordResult> startResult, CameraRecorder cameraRecorder, ExecutorService recordExecutor) {
        this.mStartResult = startResult;
        this.mCameraRecorder = cameraRecorder;
        this.mRecordExecutor = recordExecutor;
        if (this.mCallbackExecutor == null) {
            this.mCallbackExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setName("WeCamera-RecordThread");
                    return thread;
                }
            });
        }
        this.mCallbackExecutor.submit(new Runnable(){

            @Override
            public void run() {
                RecordResult startResult = (RecordResult)WeRecordController.this.mStartResult.get();
                if (startResult != null && startResult.ok()) {
                    WeRecordController.this.addAutoTask(startResult.recordConfig());
                }
            }
        });
    }

    @Override
    public RecordController whenRecordStarted(final RecordStartListener recordStartListener) {
        this.mCallbackExecutor.submit(new Runnable(){

            @Override
            public void run() {
                RecordResult startResult = (RecordResult)WeRecordController.this.mStartResult.get();
                WeRecordController.this.mRecordListener = startResult.recordConfig().recordListener();
                WeRecordController.this.notifyRecordStart(recordStartListener, startResult);
            }
        });
        return this;
    }

    @Override
    public RecordController whenRecordStopped(final RecordStopListener recordStoppedListener) {
        this.mCallbackExecutor.submit(new Runnable(){

            @Override
            public void run() {
                if (!WeRecordController.this.mCameraRecorder.isRecordStarted()) {
                    return;
                }
                WeCameraLogger.d(WeRecordController.TAG, "stop listener executor start", new Object[0]);
                try {
                    WeRecordController.this.mRecordFinishLatch.await();
                }
                catch (InterruptedException e2) {
                    WeCameraLogger.e(WeRecordController.TAG, e2, "stop latch interrupted.", new Object[0]);
                }
                WeCameraLogger.d(WeRecordController.TAG, "stop task created, wait get result.", new Object[0]);
                RecordResult stopResult = null;
                if (WeRecordController.this.stopTask == null) {
                    return;
                }
                try {
                    stopResult = (RecordResult)WeRecordController.this.stopTask.get();
                }
                catch (Exception e3) {
                    WeCameraLogger.e(WeRecordController.TAG, e3, "get stop record result exception", new Object[0]);
                }
                WeRecordController.this.notifyRecordStop(recordStoppedListener, stopResult);
            }
        });
        return this;
    }

    @Override
    public boolean isRecordStarted() {
        return this.mCameraRecorder.isRecordStarted();
    }

    @Override
    public RecordCanceler whenRecordCanceled(final RecordCancelListener recordCancelListener) {
        this.mCallbackExecutor.submit(new Runnable(){

            @Override
            public void run() {
                RecordResult recordCancel = null;
                try {
                    WeRecordController.this.mRecordFinishLatch.await();
                }
                catch (InterruptedException e2) {
                    WeCameraLogger.e(WeRecordController.TAG, e2, "wait record finish latch exception", new Object[0]);
                }
                if (WeRecordController.this.mCancelTask == null) {
                    return;
                }
                try {
                    recordCancel = (RecordResult)WeRecordController.this.mCancelTask.get();
                }
                catch (Exception e3) {
                    WeCameraLogger.e(WeRecordController.TAG, e3, "get cancel record result exception", new Object[0]);
                }
                WeRecordController.this.notifyRecordCancel(recordCancelListener, recordCancel);
            }
        });
        return null;
    }

    @Override
    public RecordStopper stopRecord() {
        if (this.mCameraRecorder.isRecordStarted()) {
            final Result<RecordResult> result = this.mCameraRecorder.stopRecord();
            WeCameraLogger.d(TAG, "camera record is running & stop record.", new Object[0]);
            this.stopTask = new FutureTask<RecordResult>(new Callable<RecordResult>(){

                @Override
                public RecordResult call() throws Exception {
                    return (RecordResult)result.get();
                }
            });
            this.mRecordExecutor.submit(this.stopTask);
            this.mRecordFinishLatch.countDown();
        }
        return this;
    }

    @Override
    public RecordCanceler cancelRecord() {
        if (this.mCameraRecorder.isRecordStarted()) {
            final Result<RecordResult> recordResultResult = this.mCameraRecorder.cancelRecord();
            WeCameraLogger.d(TAG, "camera record is running & cancel record.", new Object[0]);
            this.mCancelTask = new FutureTask<RecordResult>(new Callable<RecordResult>(){

                @Override
                public RecordResult call() throws Exception {
                    return (RecordResult)recordResultResult.get();
                }
            });
            this.mRecordExecutor.submit(this.mCancelTask);
            this.mRecordFinishLatch.countDown();
        }
        return this;
    }

    private void addAutoTask(final RecordConfig recordConfig) {
        this.mHandlerThread = new HandlerThread("auto_stop_record");
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        final int[] timer = new int[1];
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (WeRecordController.this.mCameraRecorder.isRecordStarted()) {
                    timer[0] = timer[0] + 1;
                    RecordListener recordListener = recordConfig.recordListener();
                    WeRecordController.this.notifyRecordIng(recordListener, timer[0]);
                    WeRecordController.this.mHandler.postDelayed((Runnable)this, 1000L);
                }
            }
        }, 1000L);
        if (recordConfig.durationInMillis() > 0L) {
            WeCameraLogger.i(TAG, "send auto stop after " + recordConfig.durationInMillis() + "ms.", new Object[0]);
            Runnable autoStopTask = new Runnable(){

                @Override
                public void run() {
                    WeCameraLogger.d(WeRecordController.TAG, "auto stop task came.", new Object[0]);
                    if (WeRecordController.this.mCameraRecorder.isRecordStarted()) {
                        WeCameraLogger.i(WeRecordController.TAG, "auto stop occur && stop record", new Object[0]);
                        WeRecordController.this.stopRecord();
                    }
                    WeRecordController.this.mHandlerThread.quit();
                }
            };
            this.mHandler.postDelayed(autoStopTask, recordConfig.durationInMillis());
        }
    }

    private void notifyRecordIng(final RecordListener recordListener, final int interval) {
        WeUI.post(new Runnable(){

            @Override
            public void run() {
                if (recordListener != null) {
                    recordListener.onRecordIng(interval);
                }
            }
        });
    }

    private void notifyRecordStart(final RecordStartListener recordStartListener, final RecordResult startResult) {
        WeUI.post(new Runnable(){

            @Override
            public void run() {
                if (WeRecordController.this.mRecordListener != null) {
                    WeRecordController.this.mRecordListener.onRecordStart(startResult);
                }
                recordStartListener.onRecordStart(startResult);
            }
        });
    }

    private void notifyRecordStop(final RecordStopListener recordStoppedListener, final RecordResult stopResult) {
        WeUI.post(new Runnable(){

            @Override
            public void run() {
                if (WeRecordController.this.mRecordListener != null) {
                    WeRecordController.this.mRecordListener.onRecordStop(stopResult);
                }
                recordStoppedListener.onRecordStop(stopResult);
            }
        });
    }

    private void notifyRecordCancel(final RecordCancelListener recordCancelListener, final RecordResult recordCancel) {
        WeUI.post(new Runnable(){

            @Override
            public void run() {
                if (WeRecordController.this.mRecordListener != null) {
                    WeRecordController.this.mRecordListener.onRecordCancel(recordCancel);
                }
                recordCancelListener.onRecordCancel(recordCancel);
            }
        });
    }
}

