/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera;

import android.content.Context;
import com.webank.mbank.wecamera.CameraListener;
import com.webank.mbank.wecamera.WeCamera;
import com.webank.mbank.wecamera.config.CameraConfigSelectors;
import com.webank.mbank.wecamera.config.ConfigOperate;
import com.webank.mbank.wecamera.config.DisplayOrientationOperator;
import com.webank.mbank.wecamera.config.FeatureSelector;
import com.webank.mbank.wecamera.config.feature.CameraFacing;
import com.webank.mbank.wecamera.config.feature.Fps;
import com.webank.mbank.wecamera.config.feature.ScaleType;
import com.webank.mbank.wecamera.config.feature.Size;
import com.webank.mbank.wecamera.config.selector.FlashModeSelectors;
import com.webank.mbank.wecamera.config.selector.FocusModeSelectors;
import com.webank.mbank.wecamera.config.selector.SizeSelectors;
import com.webank.mbank.wecamera.error.CameraErrorCallback;
import com.webank.mbank.wecamera.error.CameraErrors;
import com.webank.mbank.wecamera.hardware.CameraProvider;
import com.webank.mbank.wecamera.hardware.CameraProviders;
import com.webank.mbank.wecamera.log.WeCameraLogger;
import com.webank.mbank.wecamera.preview.WePreviewCallback;
import com.webank.mbank.wecamera.video.config.RecordConfig;
import com.webank.mbank.wecamera.view.CameraView;
import java.util.ArrayList;
import java.util.List;

public class WeCameraBuilder {
    private Context mContext;
    private CameraProvider mCameraProvider = CameraProviders.v1();
    private ScaleType mScaleType = ScaleType.CROP_CENTER;
    private CameraFacing mCameraFacing = CameraFacing.BACK;
    private CameraView mCameraView;
    private WePreviewCallback mWePreviewCallback = null;
    private FeatureSelector<String> mFlashModeSelector = FlashModeSelectors.firstAvailable(FlashModeSelectors.redEye(), FlashModeSelectors.autoFlash(), FlashModeSelectors.torch(), FlashModeSelectors.off());
    private FeatureSelector<String> mFocusModeSelector = FlashModeSelectors.firstAvailable(FocusModeSelectors.continuousPicture(), FocusModeSelectors.autoFocus(), FocusModeSelectors.fixed());
    private FeatureSelector<Size> mPreviewSizeSelector = SizeSelectors.maxArea();
    private FeatureSelector<Size> mPictureSizeSelector = SizeSelectors.maxArea();
    private FeatureSelector<Size> mVideoSizeSelector = SizeSelectors.maxArea();
    private FeatureSelector<Fps> mFpsFeatureSelector;
    private float mZoom = 0.0f;
    private CameraListener mCameraListener;
    private List<ConfigOperate> mConfigOperateList = new ArrayList<ConfigOperate>();
    private DisplayOrientationOperator mDisplayOrientationOperator;
    private RecordConfig mRecordConfig;

    public WeCameraBuilder recordConfig(RecordConfig config) {
        this.mRecordConfig = config;
        return this;
    }

    public RecordConfig recordConfig() {
        return this.mRecordConfig;
    }

    public WeCameraBuilder(Context context) {
        this.mContext = context;
    }

    public static WeCameraBuilder with(Context ctx) {
        return new WeCameraBuilder(ctx);
    }

    public WeCamera build() {
        WeCameraLogger.d("WeCamera", "wecamera version:v1.0.22", new Object[0]);
        CameraConfigSelectors cameraConfigSelectors = new CameraConfigSelectors().previewSize(this.mPreviewSizeSelector).pictureSize(this.mPictureSizeSelector).videoSize(this.mVideoSizeSelector).flashMode(this.mFlashModeSelector).focusMode(this.mFocusModeSelector).fps(this.mFpsFeatureSelector).zoom(this.mZoom).configOperates(this.mConfigOperateList).displayOrientationOperator(this.mDisplayOrientationOperator);
        return new WeCamera(this.mContext, this.mCameraProvider, this.mCameraView, this.mCameraFacing, cameraConfigSelectors, this.mScaleType, this.mCameraListener, this.mWePreviewCallback, this.mRecordConfig);
    }

    public WeCameraBuilder addConfig(ConfigOperate configOperate) {
        if (configOperate != null && !this.mConfigOperateList.contains(configOperate)) {
            this.mConfigOperateList.add(configOperate);
        }
        return this;
    }

    public WeCameraBuilder previewFrameProcessor(WePreviewCallback wePreviewCallback) {
        this.mWePreviewCallback = wePreviewCallback;
        return this;
    }

    public WeCameraBuilder displayOrientationOperator(DisplayOrientationOperator displayOrientationOperator) {
        this.mDisplayOrientationOperator = displayOrientationOperator;
        return this;
    }

    public WeCameraBuilder into(CameraView cameraView) {
        if (cameraView != null) {
            this.mCameraView = cameraView;
        }
        return this;
    }

    public WeCameraBuilder cameraListener(CameraListener cameraListener) {
        this.mCameraListener = cameraListener;
        return this;
    }

    public WeCameraBuilder previewScale(ScaleType scaleType) {
        if (scaleType != null) {
            this.mScaleType = scaleType;
        }
        return this;
    }

    public WeCameraBuilder zoom(float zoom) {
        if (zoom > 1.0f || zoom < 0.0f) {
            zoom = 0.0f;
        }
        this.mZoom = zoom;
        return this;
    }

    public WeCameraBuilder flashMode(FeatureSelector<String> flashMode) {
        if (flashMode != null) {
            this.mFlashModeSelector = flashMode;
        }
        return this;
    }

    public WeCameraBuilder focusMode(FeatureSelector<String> focusMode) {
        if (focusMode != null) {
            this.mFocusModeSelector = focusMode;
        }
        return this;
    }

    public WeCameraBuilder previewSize(FeatureSelector<Size> previewSize) {
        if (previewSize != null) {
            this.mPreviewSizeSelector = previewSize;
        }
        return this;
    }

    public WeCameraBuilder pictureSize(FeatureSelector<Size> pictureSize) {
        if (pictureSize != null) {
            this.mPictureSizeSelector = pictureSize;
        }
        return this;
    }

    public WeCameraBuilder fps(FeatureSelector<Fps> fps) {
        if (fps != null) {
            this.mFpsFeatureSelector = fps;
        }
        return this;
    }

    public WeCameraBuilder facing(CameraFacing facing) {
        if (facing == null) {
            facing = CameraFacing.FRONT;
        }
        this.mCameraFacing = facing;
        return this;
    }

    public WeCameraBuilder provider(CameraProvider cameraProvider) {
        if (cameraProvider != null) {
            this.mCameraProvider = cameraProvider;
        }
        return this;
    }

    public WeCameraBuilder logger(WeCameraLogger.ILog log) {
        if (log != null) {
            WeCameraLogger.setLogger(log);
        }
        return this;
    }

    public WeCameraBuilder errorCallback(CameraErrorCallback errorCallback) {
        if (errorCallback != null) {
            CameraErrors.setErrorCallback(errorCallback);
        }
        return this;
    }
}

