/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.video.config;

import android.media.CamcorderProfile;
import com.webank.mbank.wecamera.config.ConfigOperate;
import com.webank.mbank.wecamera.config.FeatureSelector;
import com.webank.mbank.wecamera.config.feature.Size;
import com.webank.mbank.wecamera.video.RecordListener;
import com.webank.mbank.wecamera.video.config.DefaultVideoNameGenerator;
import com.webank.mbank.wecamera.video.config.VideoNameGenerator;
import com.webank.mbank.wecamera.video.config.WeCamcorderConfigSelector;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class RecordConfig {
    private long recordDuration;
    private TimeUnit recordDurationUnit;
    private String outDir;
    private VideoNameGenerator mVideoNameGenerator = new DefaultVideoNameGenerator();
    private RecordListener mRecordListener;
    private FeatureSelector<CamcorderProfile> mCamcorderProfileSelector = new WeCamcorderConfigSelector(new int[0]);
    private int videoBitRate = -1;
    private int audioSampleRate = -1;
    private int videoCodec = -1;
    private int fileFormat = -1;
    private FeatureSelector<Size> videoFrameSize;
    private int audioSource = 1;
    private int videoSource = 1;
    private FeatureSelector<String> focusMode;
    private List<ConfigOperate> mConfigOperates = new ArrayList<ConfigOperate>();

    public void addRecordConfig(ConfigOperate configOperate) {
        if (configOperate != null && !this.mConfigOperates.contains(configOperate)) {
            this.mConfigOperates.add(configOperate);
        }
    }

    public FeatureSelector<String> focusMode() {
        return this.focusMode;
    }

    public RecordConfig focusMode(FeatureSelector<String> focusMode) {
        this.focusMode = focusMode;
        return this;
    }

    public int audioSource() {
        return this.audioSource;
    }

    public RecordConfig audioSource(int audioSource) {
        this.audioSource = audioSource;
        return this;
    }

    public int videoSource() {
        return this.videoSource;
    }

    public RecordConfig videoSource(int videoSource) {
        this.videoSource = videoSource;
        return this;
    }

    public List<ConfigOperate> configOperates() {
        return this.mConfigOperates;
    }

    public FeatureSelector<Size> videoFrameSize() {
        return this.videoFrameSize;
    }

    public RecordConfig videoFrameSize(FeatureSelector<Size> videoFrameSize) {
        this.videoFrameSize = videoFrameSize;
        return this;
    }

    public int videoCodec() {
        return this.videoCodec;
    }

    public RecordConfig videoCodec(int videoCodec) {
        this.videoCodec = videoCodec;
        return this;
    }

    public int fileFormat() {
        return this.fileFormat;
    }

    public RecordConfig fileFormat(int fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    public int videoBitRate() {
        return this.videoBitRate;
    }

    public RecordConfig videoBitRate(int videoBitRate) {
        this.videoBitRate = videoBitRate;
        return this;
    }

    public VideoNameGenerator videoNameGenerator() {
        return this.mVideoNameGenerator;
    }

    public RecordConfig videoNameGenerator(VideoNameGenerator videoNameGenerator) {
        if (videoNameGenerator != null) {
            this.mVideoNameGenerator = videoNameGenerator;
        }
        return this;
    }

    public int audioSampleRate() {
        return this.audioSampleRate;
    }

    public RecordConfig audioSampleRate(int audioSampleRate) {
        this.audioSampleRate = audioSampleRate;
        return this;
    }

    public RecordListener recordListener() {
        return this.mRecordListener;
    }

    public RecordConfig recordListener(RecordListener recordListener) {
        this.mRecordListener = recordListener;
        return this;
    }

    public FeatureSelector<CamcorderProfile> camcorderProfileSelector() {
        return this.mCamcorderProfileSelector;
    }

    public RecordConfig camcorderProfileSelector(FeatureSelector<CamcorderProfile> camcorderProfileSelector) {
        this.mCamcorderProfileSelector = camcorderProfileSelector;
        return this;
    }

    public RecordConfig duration(long durationInMillis) {
        return this.duration(durationInMillis, TimeUnit.MILLISECONDS);
    }

    public RecordConfig duration(long recordDuration, TimeUnit timeUnit) {
        if (recordDuration < 0L) {
            throw new IllegalArgumentException("recordDuration must > 0");
        }
        this.recordDuration = recordDuration;
        this.recordDurationUnit = timeUnit;
        return this;
    }

    public long durationInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.recordDuration, this.recordDurationUnit);
    }

    public String outDir() {
        return this.outDir;
    }

    public RecordConfig outDir(String outDir) {
        this.outDir = outDir;
        return this;
    }

    public static RecordConfig create() {
        return new RecordConfig();
    }
}

