/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.config;

import com.webank.mbank.wecamera.config.feature.Fps;
import com.webank.mbank.wecamera.config.feature.Size;
import java.util.HashMap;
import java.util.Map;

public class CameraConfig {
    private HashMap<TYPE, Object> configs = new HashMap();

    public HashMap<TYPE, Object> configs() {
        return this.configs;
    }

    public Size previewSize() {
        return (Size)this.configs.get((Object)TYPE.PREVIEW_SIZE);
    }

    public CameraConfig previewSize(Size previewSize) {
        if (previewSize != null) {
            this.configs.put(TYPE.PREVIEW_SIZE, previewSize);
        }
        return this;
    }

    public Size videoSize() {
        return (Size)this.configs.get((Object)TYPE.VIDEO_SIZE);
    }

    public CameraConfig videoSize(Size videoSize) {
        if (videoSize != null) {
            this.configs.put(TYPE.VIDEO_SIZE, videoSize);
        }
        return this;
    }

    public Fps fps() {
        return (Fps)this.configs.get((Object)TYPE.FPS);
    }

    public CameraConfig fps(Fps fps) {
        if (fps != null) {
            this.configs.put(TYPE.FPS, fps);
        }
        return this;
    }

    public Size pictureSize() {
        return (Size)this.configs.get((Object)TYPE.PICTURE_SIZE);
    }

    public CameraConfig pictureSize(Size pictureSize) {
        if (pictureSize != null) {
            this.configs.put(TYPE.PICTURE_SIZE, pictureSize);
        }
        return this;
    }

    public float zoom() {
        Object zoom = this.configs.get((Object)TYPE.ZOOM);
        if (zoom == null) {
            return -1.0f;
        }
        return ((Float)zoom).floatValue();
    }

    public CameraConfig zoom(float zoom) {
        if (zoom >= 0.0f && zoom <= 1.0f) {
            this.configs.put(TYPE.ZOOM, Float.valueOf(zoom));
        }
        return this;
    }

    public String flashMode() {
        return (String)this.configs.get((Object)TYPE.FLASH_MODE);
    }

    public CameraConfig flashMode(String flashMode) {
        if (flashMode != null) {
            this.configs.put(TYPE.FLASH_MODE, flashMode);
        }
        return this;
    }

    public String focusMode() {
        return (String)this.configs.get((Object)TYPE.FOCUS_MODE);
    }

    public CameraConfig focusMode(String focusMode) {
        if (focusMode != null) {
            this.configs.put(TYPE.FOCUS_MODE, focusMode);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CameraConfig:\n--------------------------------------\n");
        for (Map.Entry<TYPE, Object> next : this.configs.entrySet()) {
            TYPE type = next.getKey();
            builder.append((Object)type).append(":");
            Object value = next.getValue();
            if (value == null) continue;
            if (value instanceof Size) {
                builder.append(value.toString());
            } else if (value instanceof String) {
                builder.append(value);
            } else {
                builder.append(value.toString());
            }
            builder.append("\n");
        }
        builder.append("--------------------------------------");
        return builder.toString();
    }

    public static enum TYPE {
        PREVIEW_SIZE("previewSize"),
        PICTURE_SIZE("pictureSize"),
        ZOOM("zoom"),
        FLASH_MODE("flashMode"),
        FOCUS_MODE("focusMode"),
        FPS("fps"),
        VIDEO_SIZE("videoSize");

        private String type;

        private TYPE(String type) {
            this.type = type;
        }

        public String type() {
            return this.type;
        }
    }
}

