/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.hardware.v1;

import android.hardware.Camera;
import com.webank.mbank.wecamera.config.CameraSupportFeatures;
import com.webank.mbank.wecamera.config.utils.V1CameraConvector;
import com.webank.mbank.wecamera.error.CameraErrors;
import com.webank.mbank.wecamera.error.CameraException;
import com.webank.mbank.wecamera.hardware.CameraFeatureCollector;
import com.webank.mbank.wecamera.hardware.v1.CameraV1;
import com.webank.mbank.wecamera.log.WeCameraLogger;
import java.util.List;

public class V1FeatureCollector
implements CameraFeatureCollector {
    private static final String TAG = "V1FeatureCollector";
    private CameraV1 mCamera;

    public V1FeatureCollector(CameraV1 camera) {
        this.mCamera = camera;
    }

    @Override
    public CameraSupportFeatures getCameraFeatures() {
        try {
            CameraSupportFeatures cameraFeature = new CameraSupportFeatures();
            Camera.Parameters parameters = this.mCamera.camera().getParameters();
            List supportedPreviewSizes = parameters.getSupportedPreviewSizes();
            List supportedVideoSizes = parameters.getSupportedVideoSizes();
            List supportedPictureSizes = parameters.getSupportedPictureSizes();
            List supportedFlashModes = parameters.getSupportedFlashModes();
            List supportedFocusModes = parameters.getSupportedFocusModes();
            boolean zoomSupported = parameters.isZoomSupported();
            cameraFeature.zoomSupport(zoomSupported);
            cameraFeature.supportFlashModes(supportedFlashModes);
            cameraFeature.supportFocusModes(supportedFocusModes);
            cameraFeature.supportPreviewSizes(V1CameraConvector.convertAndSortSize(supportedPreviewSizes));
            cameraFeature.supportPictureSizes(V1CameraConvector.convertAndSortSize(supportedPictureSizes));
            cameraFeature.supportVideoSizes(V1CameraConvector.convertAndSortSize(supportedVideoSizes));
            cameraFeature.preferredPreviewSize4Video(V1CameraConvector.convert(parameters.getPreferredPreviewSizeForVideo()));
            cameraFeature.fps(V1CameraConvector.convertAndSortFps(parameters.getSupportedPreviewFpsRange()));
            this.mCamera.cameraSupportFeatures(cameraFeature);
            WeCameraLogger.d(TAG, "get camera features success", new Object[0]);
            return cameraFeature;
        }
        catch (Throwable e2) {
            CameraErrors.throwError(CameraException.ofFatal(21, "get camera feature failed.", e2));
            return null;
        }
    }
}

