/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.youtufacelive.tools;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    private FileUtils() {
        throw new AssertionError();
    }

    public static StringBuilder readAssetFile(Context context, String string) {
        StringBuilder stringBuilder = new StringBuilder("");
        BufferedReader bufferedReader = null;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(context.getResources().getAssets().open(string));
            bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!stringBuilder.toString().equals("")) {
                    stringBuilder.append("\r\n");
                }
                stringBuilder.append(string2);
            }
            StringBuilder stringBuilder2 = stringBuilder;
            return stringBuilder2;
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException occurred. ", iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException("IOException occurred. ", iOException);
                }
            }
        }
    }

    public static StringBuilder readFile(String string) {
        File file = new File(string);
        StringBuilder stringBuilder = new StringBuilder("");
        if (file == null || !file.isFile()) {
            return null;
        }
        BufferedReader bufferedReader = null;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(file));
            bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!stringBuilder.toString().equals("")) {
                    stringBuilder.append("\r\n");
                }
                stringBuilder.append(string2);
            }
            StringBuilder stringBuilder2 = stringBuilder;
            return stringBuilder2;
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException occurred. ", iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException("IOException occurred. ", iOException);
                }
            }
        }
    }

    public static boolean copyAsset(AssetManager assetManager, String string, String string2) {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = assetManager.open(string);
            new File(string2).createNewFile();
            fileOutputStream = new FileOutputStream(string2);
            FileUtils.copyFile(inputStream, fileOutputStream);
            inputStream.close();
            inputStream = null;
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean copySdCardFile(String string, String string2) {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            new File(string2).createNewFile();
            fileOutputStream = new FileOutputStream(string2);
            FileUtils.copyFile(fileInputStream, fileOutputStream);
            ((InputStream)fileInputStream).close();
            fileInputStream = null;
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static void copyFileOrDir(AssetManager assetManager, String string, String string2) {
        String[] stringArray = null;
        try {
            stringArray = assetManager.list(string);
            if (stringArray.length == 0) {
                FileUtils.copyAsset(assetManager, string, string2 + "/" + string);
            } else {
                String string3 = null;
                string3 = string2.endsWith(File.separator) ? string2 + string : string2 + File.separator + string;
                File file = new File(string3);
                if (!file.exists()) {
                    file.mkdir();
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    FileUtils.copyFileOrDir(assetManager, string + "/" + stringArray[i], string2);
                }
            }
        }
        catch (IOException iOException) {
            Log.e((String)"tag", (String)"I/O Exception", (Throwable)iOException);
        }
    }

    public static void copyFile(InputStream inputStream, OutputStream outputStream) {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        BitmapDrawable bitmapDrawable;
        Bitmap bitmap = null;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        bitmap = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmapDrawable = new Canvas(bitmap);
        drawable.setBounds(0, 0, bitmapDrawable.getWidth(), bitmapDrawable.getHeight());
        drawable.draw((Canvas)bitmapDrawable);
        return bitmap;
    }

    public static boolean zipFileAtPath(String string, String string2) {
        int n = 2048;
        File file = new File(string);
        try {
            BufferedInputStream bufferedInputStream = null;
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
            if (file.isDirectory()) {
                FileUtils.a(zipOutputStream, file, file.getParent().length());
            } else {
                int n2;
                byte[] byArray = new byte[2048];
                FileInputStream fileInputStream = new FileInputStream(string);
                bufferedInputStream = new BufferedInputStream(fileInputStream, 2048);
                ZipEntry zipEntry = new ZipEntry(FileUtils.getLastPathComponent(string));
                zipOutputStream.putNextEntry(zipEntry);
                while ((n2 = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                    zipOutputStream.write(byArray, 0, n2);
                }
            }
            zipOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private static void a(ZipOutputStream zipOutputStream, File file, int n) {
        int n2 = 2048;
        File[] fileArray = file.listFiles();
        BufferedInputStream bufferedInputStream = null;
        for (File file2 : fileArray) {
            int n3;
            if (file2.isDirectory()) {
                FileUtils.a(zipOutputStream, file2, n);
                continue;
            }
            byte[] byArray = new byte[2048];
            String string = file2.getPath();
            String string2 = string.substring(n);
            FileInputStream fileInputStream = new FileInputStream(string);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 2048);
            ZipEntry zipEntry = new ZipEntry(string2);
            zipOutputStream.putNextEntry(zipEntry);
            while ((n3 = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                zipOutputStream.write(byArray, 0, n3);
            }
            bufferedInputStream.close();
        }
    }

    public static String getLastPathComponent(String string) {
        String[] stringArray = string.split("/");
        if (stringArray.length == 0) {
            return "";
        }
        String string2 = stringArray[stringArray.length - 1];
        return string2;
    }

    public static void deleteFile(File file) {
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                file.delete();
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                FileUtils.deleteFile(fileArray[i]);
            }
            file.delete();
        }
    }
}

