/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.hardware.v1;

import android.hardware.Camera;
import android.view.SurfaceView;
import com.webank.mbank.wecamera.config.CameraConfig;
import com.webank.mbank.wecamera.config.CameraConfigSelectors;
import com.webank.mbank.wecamera.config.CameraSupportFeatures;
import com.webank.mbank.wecamera.config.DisplayOrientationOperator;
import com.webank.mbank.wecamera.config.feature.CameraFacing;
import com.webank.mbank.wecamera.config.feature.Size;
import com.webank.mbank.wecamera.error.CameraErrors;
import com.webank.mbank.wecamera.error.CameraException;
import com.webank.mbank.wecamera.face.FaceDetector;
import com.webank.mbank.wecamera.hardware.CameraDevice;
import com.webank.mbank.wecamera.hardware.CameraV;
import com.webank.mbank.wecamera.hardware.v1.CameraV1;
import com.webank.mbank.wecamera.hardware.v1.V1CameraRecorder;
import com.webank.mbank.wecamera.hardware.v1.V1ConfigOperator;
import com.webank.mbank.wecamera.hardware.v1.V1Connector;
import com.webank.mbank.wecamera.hardware.v1.V1FaceDetector;
import com.webank.mbank.wecamera.hardware.v1.V1FeatureCollector;
import com.webank.mbank.wecamera.hardware.v1.V1PreviewOperator;
import com.webank.mbank.wecamera.hardware.v1.V1PreviewProcessor;
import com.webank.mbank.wecamera.hardware.v1.V1ZoomOperator;
import com.webank.mbank.wecamera.log.WeCameraLogger;
import com.webank.mbank.wecamera.picture.PictureResult;
import com.webank.mbank.wecamera.preview.PreviewParameter;
import com.webank.mbank.wecamera.preview.PreviewProcessor;
import com.webank.mbank.wecamera.utils.CameraUtils;
import com.webank.mbank.wecamera.video.CameraRecorder;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class CameraV1Device
implements CameraDevice {
    private static final String TAG = "CameraV1Device";
    private V1Connector mV1Connector = new V1Connector();
    private V1PreviewOperator mV1PreviewOperator;
    private CameraV1 mCamera;
    private int screenRealOrientation;

    @Override
    public CameraV open(CameraFacing type) {
        try {
            this.mV1Connector.open(type);
            this.mCamera = this.mV1Connector.cameraV();
            this.mCamera.cameraSupportFeatures(this.getCameraFeatures());
            this.mCamera.camera().setErrorCallback(new Camera.ErrorCallback(){

                public void onError(int error, Camera camera) {
                    CameraErrors.throwError(CameraException.ofDevice(-1, "" + error));
                }
            });
        }
        catch (Exception e2) {
            CameraErrors.throwError(CameraException.ofFatal(1, "open camera exception", e2));
        }
        return this.mCamera;
    }

    @Override
    public void close() {
        this.mV1Connector.close();
        this.mCamera = null;
    }

    @Override
    public void startPreview() {
        this.mV1PreviewOperator = new V1PreviewOperator(this.mCamera.camera());
        this.mV1PreviewOperator.startPreview();
    }

    @Override
    public void stopPreview() {
        if (this.mV1PreviewOperator != null) {
            this.mV1PreviewOperator.stopPreview();
            this.mV1PreviewOperator = null;
        } else {
            CameraErrors.throwError(CameraException.ofStatus(81, "you must start preview first"));
        }
    }

    @Override
    public void setDisplayView(Object displayView) {
        if (displayView == null) {
            try {
                this.mCamera.camera().setPreviewDisplay(null);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        if (displayView instanceof SurfaceView) {
            try {
                WeCameraLogger.d(TAG, "set display view :" + displayView, new Object[0]);
                this.mCamera.camera().setPreviewDisplay(((SurfaceView)displayView).getHolder());
            }
            catch (Exception e3) {
                CameraErrors.throwError(CameraException.ofFatal(3, "set preview display failed", e3));
            }
        } else {
            CameraErrors.throwError(CameraException.ofApi(0, "displayView is null"));
        }
    }

    @Override
    public void takeZoom(float scale) {
        if (scale == -1.0f) {
            return;
        }
        V1ZoomOperator mZoomOperator = new V1ZoomOperator(this.mCamera.camera());
        mZoomOperator.takeZoom(scale);
    }

    @Override
    public CameraConfig updateConfig(CameraConfigSelectors cameraConfigs) {
        return new V1ConfigOperator(this, this.mCamera).updateConfig(cameraConfigs);
    }

    @Override
    public void setDisplayOrientation(DisplayOrientationOperator orientationOperator, int screenRealOrientation) {
        this.screenRealOrientation = screenRealOrientation;
        if (this.mCamera != null) {
            int correctRotation = -1;
            if (orientationOperator != null) {
                correctRotation = orientationOperator.getOrientation(this.mCamera, screenRealOrientation);
            }
            if (correctRotation < 0) {
                correctRotation = CameraUtils.getCorrectRotation(this.mCamera.cameraFacing(), screenRealOrientation, this.mCamera.orientation());
            }
            WeCameraLogger.d(TAG, "camera set display orientation:screenOrientation=" + screenRealOrientation + ",camera orientation=" + this.mCamera.orientation() + ",\ncalc display orientation result:" + correctRotation, new Object[0]);
            this.mCamera.camera().setDisplayOrientation(correctRotation);
        }
    }

    @Override
    public PreviewParameter getDisplayFeature() {
        PreviewParameter parameter = new PreviewParameter();
        Camera.Parameters parameters = this.mCamera.camera().getParameters();
        Camera.Size previewSize = parameters.getPreviewSize();
        int previewFormat = parameters.getPreviewFormat();
        return parameter.previewSize(new Size(previewSize.width, previewSize.height)).cameraFacing(this.mCamera.cameraFacing()).cameraOrientation(this.mCamera.orientation()).screenOrientation(this.screenRealOrientation).displayOrientation(CameraUtils.getCorrectRotation(this.mCamera.cameraFacing(), this.screenRealOrientation, this.mCamera.orientation())).imageFormat(previewFormat);
    }

    @Override
    public boolean autoFocus() {
        if (this.mCamera == null) {
            CameraErrors.throwError(CameraException.ofStatus(621, "camera is null,cannot autoFocus"));
            return false;
        }
        final boolean[] result = new boolean[]{false};
        final CountDownLatch latch = new CountDownLatch(1);
        WeCameraLogger.d(TAG, "start auto focus.", new Object[0]);
        this.mCamera.camera().autoFocus(new Camera.AutoFocusCallback(){

            public void onAutoFocus(boolean success, Camera camera) {
                WeCameraLogger.d(CameraV1Device.TAG, "auto focus finish:result=" + success, new Object[0]);
                result[0] = success;
                latch.countDown();
            }
        });
        try {
            boolean await = latch.await(2L, TimeUnit.SECONDS);
            if (!await) {
                this.mCamera.camera().cancelAutoFocus();
            }
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        WeCameraLogger.d(TAG, "get focus result:" + result[0], new Object[0]);
        return result[0];
    }

    @Override
    public PreviewProcessor getPreviewProcessor() {
        return new V1PreviewProcessor(this, this.mCamera.camera());
    }

    @Override
    public PictureResult takePicture() {
        final PictureResult pictureResult = new PictureResult();
        final CountDownLatch latch = new CountDownLatch(1);
        WeCameraLogger.d(TAG, "start take picture", new Object[0]);
        this.mCamera.camera().takePicture(null, null, new Camera.PictureCallback(){

            public void onPictureTaken(byte[] data, Camera camera) {
                WeCameraLogger.d(CameraV1Device.TAG, "on picture taken callback invoke.", new Object[0]);
                pictureResult.data(data);
                PreviewParameter displayFeature = CameraV1Device.this.getDisplayFeature();
                pictureResult.rotation(displayFeature.displayOrientation()).cameraFacing(displayFeature.cameraFacing());
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        WeCameraLogger.d(TAG, "get picture result.", new Object[0]);
        return pictureResult;
    }

    @Override
    public FaceDetector getFaceDetector() {
        if (this.mCamera == null) {
            throw new IllegalStateException("You must start camera first");
        }
        return new V1FaceDetector(this, this.mCamera.camera());
    }

    @Override
    public CameraRecorder getCameraRecorder() {
        return new V1CameraRecorder(this, this.mCamera, this.screenRealOrientation);
    }

    @Override
    public CameraSupportFeatures getCameraFeatures() {
        if (this.mCamera == null) {
            return null;
        }
        V1FeatureCollector v1FeatureOperator = new V1FeatureCollector(this.mCamera);
        return v1FeatureOperator.getCameraFeatures();
    }
}

