/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.hardware.v1;

import android.hardware.Camera;
import com.webank.mbank.wecamera.config.CameraConfig;
import com.webank.mbank.wecamera.config.CameraConfigSelectors;
import com.webank.mbank.wecamera.config.ConfigOperate;
import com.webank.mbank.wecamera.config.feature.Fps;
import com.webank.mbank.wecamera.config.feature.Size;
import com.webank.mbank.wecamera.hardware.v1.CameraV1;
import com.webank.mbank.wecamera.hardware.v1.V1ParameterOperator;
import com.webank.mbank.wecamera.log.WeCameraLogger;
import java.util.List;

public class V1BatchParameterOperator
implements V1ParameterOperator {
    private static final String TAG = "V1BatchParaOperator";
    private CameraConfig config;
    private CameraConfigSelectors mCameraConfigSelectors;

    public V1BatchParameterOperator(CameraConfig config, CameraConfigSelectors cameraConfigSelectors) {
        this.config = config;
        this.mCameraConfigSelectors = cameraConfigSelectors;
    }

    @Override
    public void operate(Camera.Parameters parameters, CameraV1 cameraV1) {
        List<ConfigOperate> configOperates;
        Fps fps;
        Size pictureSize;
        Size previewSize;
        String flashMode;
        WeCameraLogger.d(TAG, "start batch camera config.", new Object[0]);
        String focusMode = this.config.focusMode();
        if (focusMode != null) {
            parameters.setFocusMode(focusMode);
        }
        if ((flashMode = this.config.flashMode()) != null) {
            parameters.setFlashMode(flashMode);
        }
        if ((previewSize = this.config.previewSize()) != null) {
            parameters.setPreviewSize(previewSize.getWidth(), previewSize.getHeight());
        }
        if ((pictureSize = this.config.pictureSize()) != null) {
            parameters.setPictureSize(pictureSize.getWidth(), pictureSize.getHeight());
        }
        if ((fps = this.config.fps()) != null) {
            parameters.setPreviewFpsRange(fps.min(), fps.max());
        }
        if ((configOperates = this.mCameraConfigSelectors.configOperates()) != null && configOperates.size() > 0) {
            for (int i = configOperates.size() - 1; i >= 0; --i) {
                ConfigOperate configOperate = configOperates.get(i);
                if (!(configOperate instanceof V1ParameterOperator)) continue;
                ((V1ParameterOperator)configOperate).operate(parameters, cameraV1);
            }
        }
    }
}

