/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.config.feature;

import android.graphics.Point;

public class Size {
    public int width;
    public int height;

    public Size(Point point) {
        if (point != null) {
            this.width = point.x;
            this.height = point.y;
        }
    }

    public Size(Size size) {
        if (size != null) {
            this.width = size.width;
            this.height = size.height;
        }
    }

    public Size(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getArea() {
        return this.width * this.height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Size size = (Size)o;
        if (this.width != size.width) {
            return false;
        }
        return this.height == size.height;
    }

    public Size rotate() {
        return new Size(this.height, this.width);
    }

    public Size with(int displayOrientation) {
        if (displayOrientation % 180 != 0) {
            return this.rotate();
        }
        return this;
    }

    public int hashCode() {
        int result = this.width;
        result = 31 * result + this.height;
        return result;
    }

    public String toString() {
        return "{width=" + this.width + ", height=" + this.height + '}';
    }
}

